% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_mean_closed.R
\name{fit_mean_closed}
\alias{fit_mean_closed}
\title{Fitting function for open curves}
\usage{
fit_mean_closed(srv_data_curves, knots, max_iter, type, eps, pen_factor)
}
\arguments{
\item{srv_data_curves}{list of \code{data.frame}s with srv vectors in each row.
Usually a result of a call to \code{\link{get_srv_from_points}}}

\item{knots}{set of knots for the mean spline curve}

\item{max_iter}{maximal number of iterations}

\item{type}{if "smooth" linear srv-splines are used which results in a differentiable mean curve}

\item{eps}{the algorithm stops if L2 norm of coefficients changes less}

\item{pen_factor}{penalty factor forcing the mean to be closed
if "polygon" the mean will be piecewise linear.}
}
\value{
a \code{list}
with entries
  \item{type}{"smooth" or "polygon"}
  \item{coefs}{\code{coefs} srv spline coefficients of the estimated mean}
  \item{knots}{spline knots}
  \item{t_optims}{optimal parametrisation}
  \item{shift_idxs}{index of the starting point of the closed curve after alignment}
}
\description{
Fits an elastic mean for open curves. Is usually called from
\code{\link{compute_elastic_mean}}.
}
