% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chem_edgar.R
\name{chem_edgar}
\alias{chem_edgar}
\title{Agregate EDGAR emissions NetCDF files into a RasterStack by}
\usage{
chem_edgar(
  path,
  chem,
  merge = FALSE,
  k = rep(1, 34),
  recursive = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{path}{Character; path to the NetCDF files from EDGAR. The directory
\strong{must} have one file for each of the following pollutants:
"voc" from 1 to 25, "co", "nox", "nmvoc","so2", "nh3",
"pm10", "pm2.5", "bc" and "oc"}

\item{chem}{Character; chemical mechanism: "edgar", "radm", "radmsorg",
"cbmz_mosaic", "cptec", "ecb05_opt1",
"neu_cb05" (thanks to Daniel Schuch) and
"ufpr_cbmz" (thanks to Leila Martins).
\itemize{
\item When chem is "edgar" units are: "g km-2 h-1"
\item Other mechanisms: gases "mol km-2 h-1" and aerosols: "ug m-2 s-1"
}}

\item{merge}{Logical; in the case that tehre are more than one NetCDF per pollutant,
merge = TRUE will merge them with sum. Default is FALSE.}

\item{k, }{Numeric; Value to factorize each pollutant.}

\item{recursive}{Logical to search files recursive}

\item{verbose}{Logical to print more information}
}
\value{
RasterStack
}
\description{
The Emissions Database for Global Atmospheric Research (EDGAR) is a
project from the Joint Research Centre. This function reads the NetCDF and
merge/aggregate into diferent chemical mechanisms
}
\note{
Molecular weights were obtained from

Development of  Improved Chemical Speciation Database for Processing Emissions of
Volatile Organic Compounds for Air Quality Models
https://intra.engr.ucr.edu/~carter/emitdb/

Some mappings were obtained from:

Carter, W. P. (2015). Development of a database for chemical
mechanism assignments for volatile organic emissions.
Journal of the Air & Waste Management Association, 65(10), 1171-1184.

Lopez-Norena, Ana and Fernandez, Rafael & Puliafito, SALVADOR. (2019).
ESPECIACION DE INVENTARIOS DE EMISIONES DE AEROSOLES Y COMPUESTOS ORGANICOS
VOLATILES PARA EL MODELO WRF-CHEM, APLICADO A LOS ESQUEMAS RADM-2,
CBM-Z Y MOZART-4.
}
\examples{
\donttest{
# Downloading EDGAR data ####
p <- tempdir()
tot <- paste0(p, "/TOT")
dir.create(tot)

get_edgar(
  dataset = "v432_VOC_spec",
  destpath = tot,
  sector = c("TOTALS"),
  type = "nc",
  year = 2012,
  ask = FALSE
)

get_edgar(
  dataset = "v50_AP",
  destpath = tot,
  sector = c("TOTALS"),
  type = "nc",
  year = 2014,
  ask = FALSE
)

nc <- paste0(p, "/nc")

totals <- list.files(
  path = tot,
  full.names = TRUE,
  pattern = ".zip"
)

lapply(totals, unzip, exdir = nc)

r <- chem_edgar(path = nc,
                chem = "radm")
library(raster)
plot(r$E_CO)
r$E_CO[] <- ifelse(r$E_CO[] <= 0, NA, r$E_CO[])
br <- c(1.133594e-10, 0.001105391, 0.002727838, 0.007006367, 0.0146665,
0.03192566, 0.08026344, 0.5739333, 4.110863, 16.47688, 6.641064e+05)
plot(r$E_CO, col = cptcity::cpt(rev = TRUE), breaks = br)
}
}
