% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ei_good.R
\name{ei_good}
\alias{ei_good}
\title{EI iterative estimation via Goodman's Regression}
\usage{
ei_good(data, cand_cols, race_cols, totals_col)
}
\arguments{
\item{data}{A data.frame() object containing precinct-level turnout data by
race and candidate}

\item{cand_cols}{A character vector listing the column names for turnout for
each candidate}

\item{race_cols}{A character vector listing the column names for turnout by
race}

\item{totals_col}{The name of the column containing total votes cast in each
precinct}
}
\value{
matrix with precinct results, columns = race groups, rows = candidates
}
\description{
EI iterative estimation via Goodman's Regression
}
\references{
eiPack King et. al. (http://gking.harvard.edu/eiR)

L. A. Goodman. Ecological regressions and behavior of individuals. American
Sociological Review, 1953.
}
\author{
Loren Collingwood <loren.collingwood@ucr.edu>

Ari Decter-Frain <agd75@cornell.edu>
}
