% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.ego.folders.R
\name{read_egonet}
\alias{read_egonet}
\title{Read ego-centered network data exported with EgoNet software as an \code{egor} object}
\usage{
read_egonet(
  egos.file,
  alter.folder,
  edge.folder,
  csv.sep = ",",
  ID.vars = list(ego = "egoID", alter = "alterID", source = "Source", target = "Target"),
  first.col.row.names = FALSE,
  ...
)
}
\arguments{
\item{egos.file}{File name of the .csv file containing the ego data.}

\item{alter.folder}{Folder name of the folder containing the alter data in
separate .csv files for each ego/ network.}

\item{edge.folder}{Folder name of the folder containing the edge/ tie data in
separate .csv files for each ego/ network.}

\item{csv.sep}{\code{Character} indicating the separator used in csv files.}

\item{ID.vars}{A named list containing column names of the relevant
input columns: \describe{

\item{\code{ego}}{unique identifier associated with each ego, defaulting
to \code{"egoID"}; has no effect if \code{alters.df} and \code{aaties.df} are
both lists of data frames.}

\item{\code{alter}}{unique-within-ego identifier associated with each
alter, defaulting to \code{"alterID"}; optional \code{aaties.df} are not
provided.}

\item{\code{source}}{if \code{aaties.df} is provided, the column given the
alter identifier of the origin of a relation.}

\item{\code{target}}{if \code{aaties.df} is provided, the column given the
alter identifier of the destination of a relation.}

}}

\item{first.col.row.names}{\code{Boolean} indicating if first column contains
row names, that are to be skipped, default is \code{FALSE}.}

\item{...}{additional arguments to \code{\link[=egor]{egor()}}.}
}
\value{
An \strong{egor} object is returned. It is a \code{list} of three data frames:
(1) ego: \code{dataframe} of all
egos and their attributes;
(2) alter: \code{dataframe} of all alters;
(3) aatie: \code{dataframe} of alter alter ties/ edges
}
\description{
This function imports ego-centered network data from folders with separate
files for alters-level and edge data. It will run some basic checks upon
the completeness of the data and inform the user of potential problems. This
function can be used to import data exported from EgoNet (McCarty 2011).
}
\examples{
egos.file <-  system.file("extdata", "egos_32.csv", package = "egor")
alters.folder <- system.file("extdata", "alters_32", package = "egor")
edge.folder <-  system.file("extdata", "edges_32", package = "egor")

ef <- read_egonet(egos.file = egos.file, 
                          alter.folder = alters.folder, 
                          edge.folder = edge.folder, 
                          csv.sep = ";")
}
\keyword{ego-centered}
\keyword{import}
