% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GI.R
\name{GainIndex}
\alias{GainIndex}
\title{Calculate the Gain Index (GI) using JAGS}
\usage{
GainIndex(
  data,
  formula,
  random,
  intervention,
  NA.omit = TRUE,
  n.iter = 20000,
  n.chains = 3,
  n.burnin = 10000,
  inits = NULL,
  model.file = NULL,
  alpha = 0.05
)
}
\arguments{
\item{data}{A list containing the data for the JAGS model which must include
columns: School, Posttest, Pretest, Intervention. Data should not have
any missing values in these columns.}

\item{formula}{the model to be analysed is of the form y ~ x1+x2+.... Where y is the outcome variable and Xs are the independent variables. Formula does not need to include \code{Intervention} variable.}

\item{random}{a string variable specifying the "clustering variable" as contained in the data. See example below.}

\item{intervention}{a string variable specifying the "intervention variable" as appearing in the formula and the data. See example below.}

\item{NA.omit}{Optional; a logic to check if omitting missing value.
If NA.omit = TRUE, results will output the percentage of missing value in the four required columns and then JAGS results.
If NA.omit = FALSE, will give a warning "Please handle missing values before using GainIndex()."
If not provided, the function uses default TRUE.}

\item{n.iter}{Total number of iterations for the MCMC simulation.}

\item{n.chains}{Number of chains to run in the MCMC simulation.}

\item{n.burnin}{Number of burn-in iterations to be discarded before analysis.}

\item{inits}{Optional; a list of initial values for the JAGS model. If NULL,
the function generates default initial values.}

\item{model.file}{Optional; a custom path to the JAGS model file.
If not provided, the function uses default path.}

\item{alpha}{significant level, default alpha = 0.05.}
}
\value{
An S3 object containing the following components:
\describe{
\item{GI}{A data frame containing the Gain Index and its 95\% confidence intervals,
as well as the Progress Index and its 95\% confidence intervals.}
\item{Proportions}{A data frame showing the proportion of participants achieving
each level of gain (low and high) for both control and
intervention groups.}
\item{Timing}{A vector with execution time details, including user and elapsed
time in seconds.}
}
}
\description{
This function computes the Gain Index and other related statistics for educational trials.
Gain index provides a proportion of pupils who would not have make good progress without intervention.
This function supports flexible configurations for JAGS modeling.
}
\examples{
######### EXAMPLE ONE: crtData #########
\dontrun{
  data(crtData)
  output1 <- GainIndex(data = crtData, formula = Posttest~Prettest, random = "School",n.iter = 200,
                       intervention = "Intervention", NA.omit = T, alpha = 0.05)
  output1


  ########## EXAMPLE TWO: mstData ######
  data(mstData)
  output1 <- GainIndex(data = mstData, formula = Posttest~Prettest, random = "School",n.iter = 200,
                       intervention = "Intervention", NA.omit = T, alpha = 0.05)
  output1
}
}
