% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpolation.R
\name{weighted_avg_census}
\alias{weighted_avg_census}
\title{Function to compute weighted average of Census information
using imputed populations as weights}
\usage{
weighted_avg_census(mapping_df, abs_df)
}
\arguments{
\item{mapping_df}{data frame detailing how much Census divisions intersect with each 
electoral division at the time of the election.}

\item{abs_df}{data frame holding Census information from Census year}
}
\value{
data frame with imputed Census data for electoral boundaries at the time of 
the Census
}
\description{
Function to compute weighted average of Census information
using imputed populations as weights
}
\examples{
\dontrun{
data(abs2016)

# Each 2013 electorate boundary's composition in terms of the 
# boundaries in place for the 2016 Census
aec_sF_2013 <- loadShapeFile(path_to_aec_shapefile)
abs_sF_2016 <- loadShapeFile(path_to_abs_shapefile)
mapping_2016 <- mapping_fn(aec_sF = aec_sF_2013, abs_sF = abs_sF_2016)

# Estimate 2016 Census data for the 2013 electorates
imputed_data_2016 <- weighted_avg_census(mapping_df = mapping_2016, abs_df = abs2016)
}
}
