% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_scenario.R
\name{set_scenario}
\alias{set_scenario}
\title{Set the scenario for your edible city}
\usage{
set_scenario(
  x,
  pGardens = 1,
  pVacant = 1,
  pRooftop = 1,
  edible_area_garden = c(0.02, 0.3),
  edible_area_vacant = c(0.52, 0.75),
  edible_area_rooftop = c(0.6, 0.62),
  min_area_garden = 10,
  min_area_vacant = 100,
  min_area_rooftop = 100,
  private_gardens_from = "Normal garden",
  vacant_from = "Vacant",
  rooftop_from = "Rooftop",
  pCommercial = 0,
  area_field = "flat_area",
  quiet = FALSE
)
}
\arguments{
\item{x}{An 'sf' object with the urban model of your city and a 'land_use' field with categories of urban features.}

\item{pGardens}{The proportion of private gardens (land_use == 'Gardens')
that will become edible gardens [0-1].}

\item{pVacant}{The proportion of vacant plot (land_use == 'Vacant') with 'area >= min_area_vacant'
that will become edible gardens [0-1].}

\item{pRooftop}{The proportion of rooftops (land_use == 'Flat rooftop') with 'area >= min_area_rooftop'
that will become edible rooftops [0-1].}

\item{edible_area_garden}{The proportion in a range of surface in a garden that is occupied by edible plants [0-1].}

\item{edible_area_vacant}{The proportion in a range of surface in a vacant plot that is occupied by edible plants [0-1].}

\item{edible_area_rooftop}{The proportion in a range of surface in a rooftop that is occupied by edible plants [0-1].}

\item{min_area_garden}{The minimum area that a garden must have to become an edible garden.}

\item{min_area_vacant}{The minimum area that a vacant must have to become an community or commercial garden.}

\item{min_area_rooftop}{The minimum area that a flat rooftop must have to become an edible rooftop.}

\item{private_gardens_from}{The categories in 'land_uses' potentially converted to edible private gardens}

\item{vacant_from}{The categories in 'land_uses' potentially converted to community or commercial gardens}

\item{rooftop_from}{The categories in 'land_uses' potentially converted to edible rooftop
(community raised beds or commercial hydroponic)}

\item{pCommercial}{The proportion of plots and rooftop that will be commercial. The rest will be community gardens
In rooftops it is equivalent to raised beds and hydroponic system respectively.}

\item{area_field}{The field to be used as the area of each feature. If NULL, the area is calculated with
sf::st_area()}

\item{quiet}{If 'TRUE', warnings about proportions not satisfied are not triggered.}
}
\value{
An 'sf' object as 'x' with the respective proportion of gardens ('Edible private garden'),
vacant plots ('Community plot garden', 'Commercial plot garden') and rooftop gardens ('Community rooftop garden',
'Commercial hydroponic rooftop')
labeled as edible gardens.
}
\description{
You can adjust different parameters to define different city scenarios.
The object must contain a field 'land_use' which describes the function or type of each feature.
}
\details{
When pGardens, pVacant or pRooftop is lower than 1, the gardens are selected randomly among
gardens with an area larger than 'min_area_*'.
However, when pCommercial > 0, commercial gardens and hydroponic rooftops are
settled in the larger features, assuming that commercial initiatives have the power to acquire
the best spots.
}
\examples{
# Set scenario with 50\% of streets converted to community gardens
# randomly occupying between 40 and 60\% of street's area.
scenario <- set_scenario(city_example, pGardens = 0, pVacant = 0.5, pRooftop = 0,
                         edible_area_vacant = c(0.4, 0.6), vacant_from = "Streets")
table(scenario$land_use)

# Set scenario with 60\% of rooftops converted to gardens, and 30\% of those with commercial purpose.
scenario <- set_scenario(city_example, pGardens = 0, pVacant = 0, pRooftop = 0.6, pCommercial = 0.3)
table(scenario$land_use)
}
\author{
Josep Pueyo-Ros
}
