% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adult_coefs.R
\docType{data}
\name{adult_rxc_hcc_inter}
\alias{adult_rxc_hcc_inter}
\title{Adult RXC/HCC Interaction Factors - Table 9}
\format{An object of class \code{tbl_df} (inherits from \code{tbl}, \code{data.frame}) with
32 rows and 8 columns
\describe{
\item{used}{Whether or not the category is used in the RA model}
\item{plat, gold, silver, bronze, cat}{HCC grouping risk score for each
metal level}
\item{rxc}{RXC label for risk scores (Includes leading zeroes)}
\item{hcc}{HCC label for risk scores (Includes leading zeroes)}
}}
\source{
Most recent DIY entry at:
\url{https://www.cms.gov/cciio/Resources/Regulations-and-Guidance/index} \cr
Data import and cleaning at:
\url{https://github.com/ArctiCondor/edgedata/tree/master/data-raw}
}
\usage{
adult_rxc_hcc_inter
}
\description{
A dataset containing the adult model RXC/HCC interaction factors for the
risk adjustment model. Some HCCs have built-in risk for the associated
drugs, so if a member has both the diagnosis and the drug, their risk is
overstated. Other drugs combined with conditions indicate a greater severity
than either the drug or the condition alone, so risk is understated. The
RXC/HCC interaction factors make these adjustments.
}
\seealso{
Other factors: 
\code{\link{adult_demo}},
\code{\link{adult_enroll_dur}},
\code{\link{adult_group}},
\code{\link{adult_hcc}},
\code{\link{adult_interaction}},
\code{\link{adult_rxc}},
\code{\link{child_demo}},
\code{\link{child_group}},
\code{\link{child_hcc}},
\code{\link{infant_demo}},
\code{\link{infant_mat_sev}}

Other HCC tables: 
\code{\link{adult_group}},
\code{\link{adult_hcc}},
\code{\link{adult_interaction}},
\code{\link{cc_hier}},
\code{\link{child_group}},
\code{\link{child_hcc}},
\code{\link{cpt_hcpcs}},
\code{\link{icd_cc}}

Other RXC tables: 
\code{\link{adult_rxc}},
\code{\link{hcpcs_rxc}},
\code{\link{ndc_rxc}},
\code{\link{rxc_hier}}
}
\concept{HCC tables}
\concept{RXC tables}
\concept{factors}
\keyword{datasets}
