% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/full_text.R
\name{full_text}
\alias{full_text}
\title{SEC Full-Text Search}
\usage{
full_text(q = "*", type = "", reverse_order = FALSE, count = 10,
  page = 1, stemming = TRUE, name = "", cik = "", sic = "",
  from = "", to = "")
}
\arguments{
\item{q}{Search query. For details on special formatting, see the
\href{https://www.sec.gov/edgar/searchedgar/edgarfulltextfaq.htm}{FAQ}.}

\item{type}{Type of forms to search - e.g. '10-K'}

\item{reverse_order}{If true, order by oldest first instead of newest first}

\item{count}{Number of results to return}

\item{page}{Which page of results to return}

\item{stemming}{Search by base words(default) or exactly as entered}

\item{name}{Company name. Cannot be combined with `cik` or `sik`.}

\item{cik}{Company code to search. Cannot be combined with `name` or `sic`}

\item{sic}{Standard Industrial Classification of filer to search for. Cannot
be combined with `cik` or `name`. Special options - 1: all, 0:
Unspecified.}

\item{from}{Start date. Must be in the form of `mm/dd/yyyy`. Must also
specify `to`}

\item{to}{End date. Must be in the form of `mm/dd/yyyy`. Must also
specify `from`}
}
\value{
A dataframe list of results including the following columns -
 \itemize{
   \item filing_date
   \item name
   \item href
   \item company_name
   \item cik
   \item sic
   \item content
   \item parent_href
   \item index_href
 }
}
\description{
Provides access to the SEC fillings
\href{https://searchwww.sec.gov/EDGARFSClient/jsp/EDGAR_MainAccess.jsp}{full-text search tool}.
}
\examples{
full_text('intel')
}
