% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/negative_wordcloud.R
\name{NegativeWordcloud}
\alias{NegativeWordcloud}
\title{Creates wordcloud of negative words from 10-K statement.}
\usage{
NegativeWordcloud(word.frq)
}
\arguments{
\item{word.frq}{Word frequency dataframe created using
\link[edgar]{GetWordfrquency} function.}
}
\value{
Function creates wordcloud of negative words containing in the selected
10-K statement.
}
\description{
\code{NegativeWordcloud} creates the wordcloud of negative words from 10-K statement.
}
\details{
NegativeWordcloud function takes words frequency dataframe as an input from
\link[edgar]{GetWordfrquency} function. It compares this words frequency dataframe
with the negative words mentioned in the
'Loughran and McDonald Financial Sentiment Dictionaries'
and generate wordcloud using only negative words with their frequencies.
}
\examples{
\dontrun{

NegativeWordcloud(word.frq)
}
}
\references{
Loughran and McDonald Financial Sentiment Dictionaries
\url{http://www3.nd.edu/~mcdonald/Word_Lists.html}

Bill McDonald, and Tim Loughran.
Measuring Readability in Financial Disclosures.
Journal of Finance: Volume 69, Issue 4, August 2014

Bill McDonald, and Tim Loughran.
When Is a Liability Not a Liability? Textual Analysis, Dictionaries, and 10-Ks.
Journal of Finance: Volume 66, Issue 1, February 2011
}

