% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_pd}
\alias{plot_pd}
\title{Plot partial dependence from random forests}
\usage{
plot_pd(pd, facet = NULL)
}
\arguments{
\item{pd}{object of class \code{c("pd", "data.frame")} as returned by
\code{\link{partial_dependence}}}

\item{facet}{a character vector indicating the variable that should be used
to facet on if interaction is plotted. If not specified the variable with less 
unique values is chosen.}
}
\value{
a ggplot2 object
}
\description{
Plot partial dependence from random forests
}
\examples{
library(randomForest)
library(edarf)
data(iris)
fit <- randomForest(Species ~ ., iris)
pd <- partial_dependence(fit, "Petal.Width", data = iris)
plot_pd(pd)
}

