% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap_E.R
\name{bootstrap_E}
\alias{bootstrap_E}
\title{Bootstrap thermoregulation effectiveness}
\usage{
bootstrap_E(te, tb, tset_low, tset_up, index, n)
}
\arguments{
\item{te}{A vector containing operative temperatures.}

\item{tb}{A vector containing body temperature measurements.}

\item{tset_low}{Lower boundary of a species or population set-point range
that was determined through thermal preference trials in a temperature
gradient. This may be a named double vector containing the lower boundary
value, or simply the value itself.}

\item{tset_up}{Upper boundary of the set-point range.}

\item{index}{Either 'hertz' or 'blouin'.}

\item{n}{The desired number of samples drawn with replacement.}
}
\value{
The mean E and its 95 percent confidence interval obtained through
resampling with replacement n times.
}
\description{
Bootstrapping of the effectiveness of temperature regulation (E) from the
original distributions of Te and Tb as described by Hertz et al. (1993).
One can choose the number of resamples and has the option to calculate E as
defined by Hertz et al. (1993) or Blouin-Demers & Weatherhead (2001). See
\code{\link{calculate_E_hertz}} and \code{\link{calculate_E_blouin}} for
more information about these two indices.
The thermal quality of the habitat (de) and accuracy of temperature
regulation (db) are calculated as part of this formula, so it is not
necessary to run \code{\link{calculate_de}} and \code{\link{calculate_db}}
before running this function.
}
\examples{
te <- na.omit(bufbuf[,"te"])
tb <- na.omit(bufbuf[,"tb"])
E_bootstrapped <- bootstrap_E(te, tb,
                             19.35, 26.44,
                             'hertz',
                             1000)

}
\references{
Blouin-Demers, G., & Weatherhead, P. J. (2001). Thermal ecology of black rat
snakes (Elaphe obsoleta) in a thermally challenging environment. Ecology, 82
(11), 3025-3043. \cr
Hertz, P. E., Huey, R. B., & Stevenson, R. D. (1993). Evaluating temperature
regulation by field-active ectotherms: the fallacy of the inappropriate
question. The American Naturalist, 142(5), 796-818.
}
\seealso{
\code{\link{calculate_E_hertz}} and
\code{\link{calculate_E_blouin}}.
}
