% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emoa.sms-emoa.R
\name{smsemoa}
\alias{smsemoa}
\title{Implementation of the SMS-EMOA by Emmerich et al.}
\usage{
smsemoa(task, n.population = 100L, ref.point = NULL,
  parent.selector = setupSimpleSelector(),
  mutator = setupPolynomialMutator(eta = 25, p = 0.2),
  recombinator = setupSBXRecombinator(eta = 15, p = 0.7), max.iter = NULL,
  max.evals = NULL, max.time = NULL, ...)
}
\arguments{
\item{task}{[\code{ecr_optimization_task}]\cr
Optimization task. If a \code{smoof_function} is passed it is automatically
converted into a task.}

\item{n.population}{[\code{integer(1)}]\cr
Population size. Default is \code{100}.}

\item{ref.point}{[\code{numeric}]\cr
Reference point for the hypervolume computation. Default is (11, ..., 11)'
with the corresponding dimension.}

\item{parent.selector}{[\code{ecr_selector}]\cr
Selection operator which implements a procedure to copy individuals from a
given population to the mating pool, i. e., allow them to become parents.}

\item{mutator}{[\code{ecr_mutator}]\cr
Mutation operator of type \code{ecr_mutator}.}

\item{recombinator}{[\code{ecr_recombinator}]\cr
Recombination operator of type \code{ecr_recombinator}.}

\item{max.iter}{[\code{integer(1)}]\cr
Maximal number of iterations. Default ist \code{100L}.}

\item{max.evals}{[\code{integer(1)}]\cr
Maximal number of iterations/generations. Default is \code{Inf}.}

\item{max.time}{[\code{integer(1)}]\cr
Time budget in seconds. Default ist \code{Inf}.}

\item{...}{[any]\cr
Further arguments passed to \code{\link{setupECRControl}}.}
}
\value{
[\code{ecr_smsemoa_result, ecr_multi_objective_result}]
}
\description{
Pure R implementation of the SMS-EMOA. This algorithm belongs to the group
of indicator based multi-objective evolutionary algorithms. In each generation,
the SMS-EMOA selects two parents uniformly at, applies recombination and mutation
and finally selects the best subset of individuals among all subsets by maximizing
the Hypervolume indicator.
}
\note{
This helper function hides the regular \pkg{ecr} interface and offers a more
R like interface of this state of the art EMOA.
}
\references{
Beume, N., Naujoks, B., Emmerich, M., SMS-EMOA: Multiobjective selection based
on dominated hypervolume, European Journal of Operational Research, Volume 181,
Issue 3, 16 September 2007, Pages 1653-1669.
}
\keyword{optimize}

