% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/documentationEQA.R
\docType{data}
\encoding{UTF-8}
\name{glomel}
\alias{glomel}
\title{Glomel vegetation dataset}
\format{
Glomel is an object of class data.frame composed of 23 observations and 46 variables.

\describe{
\item{ID}{Station ID.}
\item{Ref}{Logical flag to indicate stations used to define the reference envelope.}
\item{Complementary}{Comments regarding the quality of the ecosystem.}
\item{...}{Percent cover values (derived from Braun-Blanquet ordinal scale) for 43 species of vascular plants.}
}
}
\description{
Vegetation data set to illustrate Ecological Quality Assessment (EQA)
}
\details{
The nature reserve of Landes et Marais de Glomel (Brittany, France) is
composed of temperate Atlantic wet heaths whose reference state is commonly
considered dominated by plant communities associated to acid, nutrient poor soils
that are at least seasonally water logged and dominated by \emph{Erica tetralix} and
\emph{E. ciliaris}. The data set consists of 23 rows and 46 columns.
The first five stations (rows) were used to define the reference
envelope, and the next 18 stations (rows) where those for which the conservation status
was to be assessed.
}
\seealso{
\code{\link{referenceEnvelopes}}
}
\author{
Aline Bifolchi, \enc{Réserve}{Reserve} Naturelle des landes et marais de Glomel
}
\keyword{data}
