% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rk4sys.R
\name{rk4sys}
\alias{rk4sys}
\title{Classical Runge-Kutta for system of equations}
\usage{
rk4sys(f, a, b, y0, n, Pars, ...)
}
\arguments{
\item{f}{function in the differential equation \eqn{y' = f(x, y)};
defined as a function \eqn{R \times R^m \rightarrow R^m}, where \eqn{m} is the number of equations.}

\item{a}{starting time for the interval to integrate}

\item{b}{ending time for the interval to integrate.}

\item{y0}{starting values at time \code{a}}

\item{n}{the number of steps from a to b.}

\item{Pars}{named list of parameters passed to f}

\item{...}{additional inputs to function \code{f}}
}
\value{
List with components x for grid points between a and b and y an
n-by-m matrix with solutions for variables in columns, i.e.
each row contains one time stamp.
}
\description{
Classical Runge-Kutta of order 4.
}
\details{
Classical Runge-Kutta of order 4 for (systems of) ordinary differential
equations with fixed step size.
Copied from pracma under GPL-3, with small modifications to work with RTMB
}
