\name{ecospat.grid.clim.dyn}

\alias{ecospat.grid.clim.dyn}

\title{Dynamic Occurrence Densities Grid}

\description{Create a grid with occurrence densities from SDM predictions. This is the dynamic version of \code{EcoSpat.grid.clim}.}

\usage{ecospat.grid.clim.dyn (glob, glob1, sp, R, th.sp, th.env)}

\arguments{
  \item{glob}{A two-column dataframe (or a vector) of the environmental values (in column) for background pixels of the whole study area (in row).}
  \item{glob1}{A two-column dataframe (or a vector) of the environmental values (in column) for the background pixels of the species (in row).}
  \item{sp}{A two-column dataframe (or a vector) of the environmental values (in column) for the occurrences of the species (in row).}
  \item{R}{The resolution of the grid.}
  \item{th.sp}{The quantile of species densities at species occurences used as a threshold to exclude low species density values.}
  \item{th.env}{The quantile of environmental densities at all study sites used as a threshold to exclude low environmental density values.}
}

\details{Using the scores of an ordination (or SDM prediction), create a grid z of RxR pixels (or a vector of R pixels when using scores of dimension 1 or SDM predictions) with occurrence densities. Only scores of one, or two dimensions can be used.}

\value{A grid z of RxR pixels (or a vector of R pixels) with z.uncor being the density of occurrence of the species, and z.cor the occupancy of the environment by the species (density of occurrences divided by the desinty of environment in the study area.}

\author{Olivier Broennimann \email{olivier.broennimann@unil.ch} and Blaise Petitpierre \email{bpetitpierre@gmail.com}}


\references{Broennimann, O., M.C. Fitzpatrick, P.B. Pearman, B. Petitpierre, L. Pellissier, N.G. Yoccoz, W. Thuiller, M.J. Fortin, C. Randin, N.E. Zimmermann, C.H. Graham and A. Guisan. 2012. Measuring ecological niche overlap from occurrence and spatial environmental data. \emph{Global Ecology and Biogeography}, \bold{21}:481-497.


Petitpierre, B., C. Kueffer, O. Broennimann, C. Randin, C. Daehler and A. Guisan. 2012. Climatic niche shifts are rare among terrestrial plant invaders.  \emph{Science}, \bold{335}:1344-1348.
}


\seealso{\code{\link{ecospat.plot.niche.dyn}}}

\examples{
\dontrun{
spp<-ecospat.testNiche
clim<-ecospat.testData[2:8]

occ.sp_test<-na.exclude(ecospat.sample.envar(dfsp=spp,colspxy=2:3,colspkept=1:3,dfvar=clim,
colvarxy=1:2,colvar="all",resolution=25))

occ.sp<-cbind(occ.sp_test,spp[,4]) #add species names

# list of species
sp.list<-levels(occ.sp[,1])
sp.nbocc<-c()

for (i in 1:length(sp.list)){sp.nbocc<-c(sp.nbocc,length(which(occ.sp[,1] == sp.list[i])))} 
#calculate the nb of occurences per species

sp.list<-sp.list[sp.nbocc>4] # remove species with less than 5 occurences
nb.sp<-length(sp.list) #nb of species
ls()
# selection of variables to include in the analyses 
# try with all and then try only worldclim Variables
Xvar<-c(3:7)
nvar<-length(Xvar)

#number of interation for the tests of equivalency and similarity
iterations<-100
#resolution of the gridding of the climate space
R=100
#################################### PCA-ENVIRONMENT ##################################
data<-rbind(occ.sp[,Xvar+1],clim[,Xvar]) 
w<-c(rep(0,nrow(occ.sp)),rep(1,nrow(clim)))
pca.cal <-dudi.pca(data, row.w = w, center = TRUE, scale = TRUE, scannf = FALSE, nf = 2)

####### selection of species ######
sp.list
sp.combn<-combn(1:2,2)

for(i in 1:ncol(sp.combn)) {
  row.sp1<-which(occ.sp[,1] == sp.list[sp.combn[1,i]]) # rows in data corresponding to sp1
  row.sp2<-which(occ.sp[,1] == sp.list[sp.combn[2,i]]) # rows in data corresponding to sp2
  name.sp1<-sp.list[sp.combn[1,i]]
  name.sp2<-sp.list[sp.combn[2,i]]
  # predict the scores on the axes
  scores.clim<- pca.cal$li[(nrow(occ.sp)+1):nrow(data),]  #scores for global climate
  scores.sp1<- pca.cal$li[row.sp1,]					#scores for sp1
  scores.sp2<- pca.cal$li[row.sp2,]					#scores for sp2
}
# calculation of occurence density and test of niche equivalency and similarity 
z1<- ecospat.grid.clim.dyn(scores.clim, scores.clim, scores.sp1,R=100)
z2<- ecospat.grid.clim.dyn(scores.clim, scores.clim, scores.sp2,R=100)
}}

