% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{pressure_ts_baltic}
\alias{pressure_ts_baltic}
\title{Baltic Sea pressure time series}
\format{
A data frame with 33 observations and 9 variables.
\describe{
\item{year}{Time variable.}
\item{nitrogen}{Mean total nitrogen input into the Baltic Sea per year.}
\item{phosphorous}{Mean total phosphorus input into the Baltic Sea per year.}
\item{surf_temp_sum}{Mean sea surface temperature in summer in the Baltic Sea per year (in °C).}
\item{bot_temp_ann}{Mean sea bottom temperature in the Baltic Sea per year (in °C).}
\item{surf_sal_sum}{Mean sea surface salinity in summer in the Baltic Sea per year.}
\item{bot_sal_ann}{Mean sea bottom salinity in the Baltic Sea per year.}
\item{bot_oxy_ann}{Mean bottom oxygen concentration in the Baltic Sea per year (in mg/m^3).}
\item{fishing_cod}{Mean eastern Baltic cod fishing pressure per year.}
}
}
\usage{
pressure_ts_baltic
}
\description{
Time series of eight environmental and anthropogenic pressures potentially affecting
the zooplankton mean size or cod spawning stock biomass in the Eastern Baltic Sea.
The time series cover the period 1984–2016 (data altered from original time series).
This dataset serves as a demo input in the \code{\link{model_exposure}} and
\code{\link{model_sensitivity}} functions.
}
\keyword{datasets}
