% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rca.R
\name{rca}
\alias{rca}
\title{Revealed comparative advantage (RCA)}
\usage{
rca(data, discrete = TRUE, cutoff = 1, tbl = TRUE,
  country = "country", product = "product", value = "value")
}
\arguments{
\item{data}{matrix or data.frame with traded values}

\item{discrete}{convert to one all the values above a cutoff and zero
otherwise (by default is TRUE)}

\item{cutoff}{all the values below the specified will be converted to zero
(by default is 1)}

\item{tbl}{TRUE (default) returns a data.frame and FALSE returns a matrix}

\item{country}{column containing countries (applies only if d is a
data.frame)}

\item{product}{column containing products (applies only if d is a
data.frame)}

\item{value}{column containing traded values (applies only if d is a
data.frame)}
}
\value{
A data frame.
}
\description{
\code{rca} computes RCA following the definition from
\insertCite{measuringcomplexity2015;textual}{economiccomplexity}
}
\details{
Given a data frame or matrix with exported values as input, this
function uses the tidyverse to obtain grouped sums and compute RCA.

Previous versions of this function used R base, but dplyr package
proved to be consistently faster for this output across different platforms
and specially in Windows.
}
\examples{
rca(ec_trade_1962)

}
\references{
For more information about RCA see:

\insertRef{measuringcomplexity2015}{economiccomplexity}

and the references therein.
}
\keyword{functions}
