% Generated by roxygen2 (4.0.0): do not edit by hand
\name{ee_map}
\alias{ee_map}
\title{LeafletJS Map}
\usage{
ee_map(ee_obj, dest = tempdir(), title = "Ecoengine species map",
  incl.data = TRUE)
}
\arguments{
\item{ee_obj}{A ecoengine object of type \code{observations} as generated by \code{\link{ee_observations}}}

\item{dest}{Location where the html file and geojson file should be stored. Default is the temp directory}

\item{title}{Title of the map.}

\item{incl.data}{Default is \code{TRUE}. Writes geoJSON data into the html file to get around security restrictions in browsers like Google Chrome. Set to \code{FALSE} to read from a separate local geoJSON file.}
}
\description{
Builds an interactive map of locations for any species
}
\examples{
\dontrun{
lynx_data <- ee_observations(genus = "Lynx", georeferenced = TRUE, page = "all", quiet = TRUE)
ee_map(lynx_data, title = "Lynx distribution map")
# Now let's map out foxes
vulpes <- ee_observations(genus = "vulpes", georeferenced = TRUE, quiet = TRUE)
ee_map(vulpes, title = "Fox distributions")
# You can also map photos
ee_map(ee_photos(georeferenced = TRUE))
}
}
\keyword{map}

