% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.r
\name{list_metrics}
\alias{list_metrics}
\alias{match_metric}
\title{Find and Browse Available Metrics}
\usage{
list_metrics(
  div = c(NA, "alpha", "beta"),
  val = c("data.frame", "list", "func", "id", "name", "div", "phylo", "weighted",
    "int_only", "true_metric"),
  nm = c(NA, "id", "name"),
  phylo = NULL,
  weighted = NULL,
  int_only = NULL,
  true_metric = NULL
)

match_metric(
  metric,
  div = NULL,
  phylo = NULL,
  weighted = NULL,
  int_only = NULL,
  true_metric = NULL
)
}
\arguments{
\item{div, phylo, weighted, int_only, true_metric}{Consider only metrics
matching specific criteria. For example, \code{div = "alpha"} will only
return alpha diversity metrics.
Default: \code{NULL}}

\item{val}{Sets the return value for this function call. See "Value"
section below. Default: \code{"data.frame"}}

\item{nm}{What value to use for the names of the returned object.
Default is \code{"id"} when \code{val} is \code{"list"} or \code{"func"}, otherwise the
default is \code{NA} (no name).}

\item{metric}{The name of an alpha/beta diversity metric to search for.
Supports partial matching. All non-alpha characters are ignored.}
}
\value{
\strong{\code{match_metric()}}

A \code{list} with the following elements.
\itemize{
\item \code{name} : Metric name, e.g. \code{"Faith's Phylogenetic Diversity"}
\item \code{id} : Metric ID - also the name of the function, e.g. \code{"faith"}
\item \code{div} : Either \code{"alpha"} or \code{"beta"}.
\item \code{phylo} : \code{TRUE} if metric requires a phylogenetic tree; \code{FALSE} otherwise.
\item \code{weighted} : \code{TRUE} if metric takes relative abundance into account; \code{FALSE} if it only uses presence/absence.
\item \code{int_only} : \code{TRUE} if metric requires integer counts; \code{FALSE} otherwise.
\item \code{true_metric} : \code{TRUE} if metric is a true metric and satisfies the triangle inequality; \code{FALSE} if it is a non-metric dissimilarity; \code{NA} for alpha diversity metrics.
\item \code{func} : The function for this metric, e.g. \code{ecodive::faith}
\item \code{params} : Formal args for \code{func}, e.g. \code{c("counts", "tree", "cpus")}
}

\strong{\code{list_metrics()}}

The returned object's type and values are controlled with the \code{val} and \code{nm} arguments.
\itemize{
\item \code{val = "data.frame"} : The data.frame from which the below options are sourced.
\item \code{val = "list"} : A list of objects as returned by \code{match_metric()} (above).
\item \code{val = "func"} : A list of functions.
\item \code{val = "id"} : A character vector of metric IDs.
\item \code{val = "name"} : A character vector of metric names.
\item \code{val = "div"} : A character vector \code{"alpha"} and/or \code{"beta"}.
\item \code{val = "phylo"} : A logical vector indicating which metrics require a tree.
\item \code{val = "weighted"} : A logical vector indicating which metrics take relative abundance into account (as opposed to just presence/absence).
\item \code{val = "int_only"} : A logical vector indicating which metrics require integer counts.
\item \code{val = "true_metric"} : A logical vector indicating which metrics are true metrics and satisfy the triangle inequality, which work better for ordinations such as PCoA.
}

If \code{nm} is set, then the names of the vector or list will be the metric ID
(\code{nm="id"}) or name (\code{nm="name"}). When \code{val="data.frame"}, the names will be
applied to the \code{rownames()} property of the \code{data.table}.
}
\description{
Programmatic access to the lists of available metrics, and their associated
functions.
}
\examples{

    # A data.frame of all available metrics.
    head(list_metrics())
    
    # All alpha diversity function names.
    list_metrics('alpha', val = 'id')
    
    # Try to find a metric named 'otus'.
    m <- match_metric('otus')
    
    # The result is a list that includes the function.
    str(m)

}
