% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cgr_s3.R
\name{plot.cgr}
\alias{plot.cgr}
\title{Plot graph of direct species associations.}
\usage{
\method{plot}{cgr}(
  x,
  P = NULL,
  vary.edge.lwd = FALSE,
  edge.col = c("light blue", "pink"),
  label = colnames(x$obj$fitted),
  vertex.col = "blue",
  label.cex = 0.8,
  edge.lwd = ifelse(vary.edge.lwd, 10, 4),
  edge.lty = c(1, 1),
  ...
)
}
\arguments{
\item{x}{is a cgr object, e.g. from output of \code{\link{cgr}}.}

\item{P}{locations of graph nodes, if NULL (default) these are generated with a Fruchterman Reingold algorithm.}

\item{vary.edge.lwd}{is logical, TRUE will vary line width according to the strength of partial correlation, default (FALSE) uses fixed line width.}

\item{edge.col}{takes two colours as arguments - the first is the colour used for positive partial correlations, the second is the colour of negative partial correlations.}

\item{label}{is a vector of labels to apply to each variable, defaulting to the column names supplied in the data.}

\item{vertex.col}{the colour of graph nodes.}

\item{label.cex}{is the size of labels.}

\item{edge.lwd}{is line width, defaulting to 10*partial correlation when varying edge width, and 4 otherwise.}

\item{edge.lty}{is a vector of two integers specifying the line types for positive and negative partial correlations, respectively. Both default to solid lines.}

\item{...}{other parameters to be passed through to plotting gplot, in particular \code{pad}, the amount to pad the plotting range is useful if labels are being clipped. For details see the \code{\link[sna:gplot]{gplot}} help file.}
}
\value{
a plot of species associations after accounting for the effect of all other species, positive/negative are blue/pink.
The matrix of node positions (\code{P}) is returned silently.
}
\description{
Plot graph of direct species associations.
}
\examples{
abund <- spider$abund[,1:5]
spider_mod <- stackedsdm(abund,~1, data = spider$x, ncores=2) 
spid_graph=cgr(spider_mod)
plot(spid_graph, edge.col=c("forestgreen","darkorchid4"), 
                 vertex.col = "black",vary.edge.lwd=TRUE)
                 
\donttest{
library(tidyr)
library(tidygraph)
library(ggraph)

igraph_out<-spid_graph$best_graph$igraph_out

igraph_out \%>\% ggraph('fr') + # see ?layout_tbl_graph_igraph
   geom_edge_fan0(aes( colour = partcor, width=partcor)) +
   scale_edge_width(range = c(0.5, 3))+
   scale_edge_color_gradient2(low="#b2182b",mid="white",high="#2166ac")+
   geom_node_text(aes(label=name), repel = TRUE)+
   geom_node_point(aes(size=1.3))+
   theme_void() +
   theme(legend.position = 'none')
}
}
\seealso{
\code{\link{gplot}}, \code{\link{cgr}}
}
