% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/echoGetFacilities.R
\name{echoGetFacilities}
\alias{echoGetFacilities}
\title{Downloads permitted facility information}
\usage{
echoGetFacilities(program, output = "df", verbose = FALSE, ...)
}
\arguments{
\item{program}{Character, either \code{program = 'caa'}, \code{program = 'cwa'}, or \code{program = 'sdw'}. \code{'caa'} retrieves facilities permitted under the Clean Air Act, \code{'cwa'} retreives facilites permitted under the Clean Water Act, and \code{'sdw'} retrives facililtes permitted under the the Safe Drinking Water Act.}

\item{output}{Character string specifying output format. \code{output = 'df'} for a dataframe or \code{output = 'sf'} for a simple features spatial dataframe. \code{'sf'} only applies to CAA and CWA queries.}

\item{verbose}{Logical, indicating whether to provide processing and retrieval messages. Defaults to FALSE.}

\item{...}{Further arguments passed as query parameters in request sent to EPA ECHO's API.}
}
\value{
dataframe or sf dataframe suitable for plotting
}
\description{
Provides interface for downloading facility information from Clean Air Act, Clean Water Act, and Safe Drinking Water Act permitted facilities.
}
