% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opts.R
\name{e_animation}
\alias{e_animation}
\title{Animation}
\usage{
e_animation(
  e,
  show = TRUE,
  threshold = NULL,
  duration = NULL,
  easing = NULL,
  delay = NULL,
  duration.update = NULL,
  easing.update = NULL,
  delay.update = NULL
)
}
\arguments{
\item{e}{An \code{echarts4r} object as returned by \code{\link{e_charts}} or
a proxy as returned by \code{\link{echarts4rProxy}}.}

\item{show}{Set to show animation.}

\item{threshold}{Whether to set graphic number threshold to animation.
Animation will be disabled when graphic number is larger than threshold.}

\item{duration}{Duration of the first animation.}

\item{easing}{Easing method used for the first animation.}

\item{delay}{Delay before updating the first animation.}

\item{duration.update}{Time for animation to complete.}

\item{easing.update}{Easing method used for animation.}

\item{delay.update}{Delay before updating animation.}
}
\description{
Customise animations.
}
\examples{
mtcars \%>\%
  e_charts(mpg) \%>\%
  e_area(drat) \%>\%
  e_animation(duration = 10000)
}
\seealso{
\href{https://echarts.apache.org/en/option.html#animation}{Additional arguments}
}
