% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{e_map_texture}
\alias{e_map_texture}
\alias{e_globe_texture}
\alias{e_composite_texture}
\alias{e_globe_dark_texture}
\alias{e_stars_texture}
\alias{e_convert_texture}
\title{Textures}
\usage{
e_map_texture(convert = TRUE)

e_globe_texture(convert = TRUE)

e_composite_texture(convert = TRUE)

e_globe_dark_texture(convert = TRUE)

e_stars_texture(convert = TRUE)

e_convert_texture(file)
}
\arguments{
\item{convert}{Converts image to JSON formatted arrays.}

\item{file}{Path to file.}
}
\description{
Path to textures.
}
\details{
Due to browser
"same origin policy" security restrictions, loading textures
from a file system in three.js may lead to a security exception,
see
\url{https://github.com/mrdoob/three.js/wiki/How-to-run-things-locally}.
References to file locations work in Shiny apps, but not in stand-alone
examples. The \code{*texture} functions facilitates transfer of image
texture data from R into textures when \code{convert} is set to \code{TRUE}.
}
\section{Functions}{

\itemize{
  \item{\code{e_map_texture} globe texture}
  \item{\code{e_stars_texture} starts texture}
  \item{\code{e_mconvert_texture} convert file to JSON formatted array}
}
}

\examples{
\dontrun{
e_map_texture(FALSE) # returns path to file
e_convert_texture("path/to/file.png") # converts file
}

}
