% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poverty.R
\name{unsatisfied_basic_needs}
\alias{unsatisfied_basic_needs}
\title{This function allows you to calculate de Unsatisfied Basic Needs}
\usage{
unsatisfied_basic_needs(
  data = ech::toy_ech_2018,
  c2 = "c2",
  c3 = "c3",
  c4 = "c4",
  d9 = "d9",
  d11 = "d11",
  d12 = "d12",
  d13 = "d13",
  d14 = "d14",
  d15 = "d15",
  d16 = "d16",
  d18 = "d18",
  d19 = "d19",
  d21_1 = "d21_1",
  d21_2 = "d21_2",
  d21_3 = "d21_3",
  d260 = "d260",
  ht19 = "ht19",
  pobre06 = "pobre06",
  e27 = "e27",
  school_enrollment = "school_enrollment",
  years_schooling = "years_schooling",
  e238 = "e238",
  anio = "anio"
)
}
\arguments{
\item{data}{data.frame}

\item{c2}{Variable name of predominant material on external walls}

\item{c3}{Variable name of predominant roofing material}

\item{c4}{Variable name of predominant flooring material}

\item{d9}{Variable name of number of rooms}

\item{d11}{Variable name of principal source of potable water}

\item{d12}{Variable name of water supply network / water access}

\item{d13}{Variable name of sanitary facilities}

\item{d14}{Variable name of bathroom presence}

\item{d15}{Variable name of private bathroom use}

\item{d16}{Variable name of sewerage facilities}

\item{d18}{Variable name of energy source for lighting}

\item{d19}{Variable name of cooking space}

\item{d21_1}{Variable name of heater or termophon presence}

\item{d21_2}{Variable name of instantaneous water heater presence}

\item{d21_3}{Variable name of fridge presence}

\item{d260}{Variable name of energy source for heating}

\item{ht19}{Variable name of number of individuals in the household}

\item{pobre06}{Variable name of poverty}

\item{e27}{Variable name of age}

\item{school_enrollment}{Variable name of school_enrollment}

\item{years_schooling}{Variable name of years_schooling}

\item{e238}{Variable name of attendance to initial education}

\item{anio}{Variable name of survey year}
}
\value{
data.frame
}
\description{
This function allows you to calculate de Unsatisfied Basic Needs
}
\details{
Based on [Fascículo I: Las Necesidades Básicas Insatisfechas a partir de los Censos 2011](https://www5.ine.gub.uy/documents/Demograf%C3%ADayEESS/PDF/Demograf%C3%ADa/Atlas_fasciculo_1_NBI_versionrevisada.pdf)
Disclaimer: This script is not an official INE product.
Aviso: El script no es un producto oficial de INE.
}
\examples{
\donttest{
toy_ech_18 <- enrolled_school(data = ech::toy_ech_2018)
toy_ech_18 <- years_of_schooling(toy_ech_18)
toy_ech_18 <- unsatisfied_basic_needs(toy_ech_18)
}
}
\seealso{
Other poverty: 
\code{\link{integrated_poverty_measure}()},
\code{\link{poverty}()}
}
\concept{poverty}
