% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dwelling.R
\name{housing_deprivation}
\alias{housing_deprivation}
\title{This function allows you to calculate the housing status}
\usage{
housing_deprivation(
  data = ech::toy_ech_2018,
  n = 1,
  ht19 = "ht19",
  d9 = "d9",
  d10 = "d10",
  d11 = "d11",
  d12 = "d12",
  d13 = "d13",
  d16 = "d16",
  d18 = "d18",
  d19 = "d19",
  c2 = "c2",
  c3 = "c3",
  c4 = "c4",
  quintil = "quintil",
  region_4 = "region_4"
)
}
\arguments{
\item{data}{data.frame}

\item{n}{number of deprivations to consider. Default 1}

\item{ht19}{Variable name of number of individuals in the household}

\item{d9}{Variable name of number of rooms}

\item{d10}{Variable name of number of rooms to sleep}

\item{d11}{Variable name of principal source of potable water}

\item{d12}{Variable name of water supply network / water access}

\item{d13}{Variable name of sanitary facilities}

\item{d16}{Variable name of sewerage facilities}

\item{d18}{Variable name of energy source for lighting}

\item{d19}{Variable name of cooking space}

\item{c2}{Variable name of predominant material on external walls}

\item{c3}{Variable name of predominant roofing material}

\item{c4}{Variable name of predominant flooring material}

\item{quintil}{Variable name of income quintil}

\item{region_4}{Variable name of region}
}
\value{
data.frame
}
\description{
This function allows you to calculate the housing status
}
\details{
Disclaimer: This script is not an official INE product.
Aviso: El script no es un producto oficial de INE.
}
\examples{
\donttest{
toy_ech_2018 <- income_constant_prices(data = ech::toy_ech_2018)
toy_ech_2018 <- income_quantiles(data = toy_ech_2018)
toy_ech_2018 <- housing_deprivation(data = toy_ech_2018)
}
}
\seealso{
Other dwelling: 
\code{\link{housing_conditions}()},
\code{\link{housing_situation}()},
\code{\link{housing_tenure}()},
\code{\link{overcrowding}()}
}
\concept{dwelling}
