% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qsld-fit-method.R
\name{qsld.fit}
\alias{qsld.fit}
\title{Fit observations to QSLD via MLE}
\usage{
qsld.fit(
  x,
  breaks,
  init.qsld,
  method = "fast.mle",
  fix.convo = NaN,
  fix.beta.a = NaN,
  fix.nu0.ratio = NaN,
  derive.mu = TRUE,
  plot.interval = 20,
  verbose.interval = 20,
  itnmax = 500
)
}
\arguments{
\item{x}{numeric, the observation of log-returns.}

\item{breaks}{numeric, the breaks for the histogram of observations. 
For \code{lme}, this parameter is only for display purpose.}

\item{init.qsld}{an object of sld class as an initial qsld guess. The user can request the utility to 
estimate the initial parameters by setting nu0 to \code{NaN}. However, t must be provided.}

\item{method}{character, optimization algorithm to use, it could be either
\code{fast.mle}, \code{mle}, or \code{pdf.lms}. Default is \code{fast.mle}.}

\item{fix.convo}{numeric, fix convolution to a specific number, default is \code{NaN}.}

\item{fix.beta.a}{numeric, fix annualized beta to a specific number, default is \code{NaN}.}

\item{fix.nu0.ratio}{numeric, fix \eqn{\nu_0/\theta} ratio to a specific number, default is \code{NaN}.}

\item{derive.mu}{logical, if specified, to derive \code{mu} automatically, default is \code{TRUE}.}

\item{plot.interval}{numeric, interval of iterations to plot the fit, default is 20.
If set to zero, the plot is disabled.}

\item{verbose.interval}{numeric, interval of iterations to print verbose message, default is 20.
If set to zero, the verbose message is disabled.}

\item{itnmax}{numeric, specify maximum iterations for optimx, default is 500.}
}
\value{
a list of two components: \code{qsld} as an object of sld class representing the QSLD fit;
        \code{optimx.out} storing the raw output from \code{optimx}.
}
\description{
This utility will fit the observations to qsld with MLE using \code{optimx}. 
There are three features:
First, it has the ability to provide initial estimate to save the user 
from the headache of guessing. 
Second, the user has the flexibility of fixing convolution, \code{beta.a}, and/or \code{nu0/theta} ratio.
And the user can ask the utility to estimate mu as well.
Third, the MLE optimization comes with two flavors: 
(a) the log-likelihood calculated from the PDF of all observations; or
(b) the log-likelihood calculated from the histogram of the observations.
The later is much faster than the former. One can use the later to obtain a good estimate,
then feed it into the former, if necessary. 
This utility also comes with an LMS regression method called "pdf.lms". This option can be used 
as a preprocessor to the MLE methods. It regresses the theoretical PDF against the empirical PDF
obtained from the histogram, and minimizes the LMS of PDF difference within 2-stdev 
and log(PDF) difference within 4-stdev.
}
\examples{
\dontrun{
  x <- ecd.data.arr("spx", lag=1, drop=1)$x
  breaks <- 200
  t <- 1/250
  d <- qsld(t=t)
  d@nu0 <- NaN # request utility to estimate
}
}
\author{
Stephen H-T. Lihn
}
\keyword{fit}
