% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecd-ccdf-method.R
\name{ecd.ccdf}
\alias{ecd.ccdf}
\title{Complementary CDF of ecd}
\usage{
ecd.ccdf(object, x, to.x = Inf, piece.wise = FALSE, f = NULL,
  verbose = FALSE)
}
\arguments{
\item{object}{An object of ecd class}

\item{x}{A numeric vector of \code{x}}

\item{to.x}{A value or a vector of starting \code{x}, default \code{Inf}
This is for internal use only.}

\item{piece.wise}{Logical. If \code{TRUE}, use cumulative method for large array.
Default to FALSE.
Use it with a scalar \code{to.x}.}

\item{f}{an optional extension to perform integral on function other than 1.
This is for internal use only. You should use the respective wrappers.}

\item{verbose}{logical, display timing information, for debugging purpose.}
}
\value{
The CCDF
}
\description{
Complementary CDF of ecd, integration of PDF from \code{x} to \code{Inf}
}
\examples{
d <- ecd()
x <- seq(0, 10, by=1)
ecd.ccdf(d,x)
}
\author{
Stephen H. Lihn
}
\keyword{cdf}

