% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/equalGADS.R
\name{equalGADS}
\alias{equalGADS}
\title{Test if two \code{GADSdat} objects are (nearly) equal}
\usage{
equalGADS(
  target,
  current,
  id = NULL,
  metaExceptions = c("display_width", "labeled"),
  tolerance = sqrt(.Machine$double.eps)
)
}
\arguments{
\item{target}{A \code{GADSdat} object.}

\item{current}{A \code{GADSdat} object.}

\item{id}{A character vector of length 1 containing the unique identifier column of both \code{GADSdat}.
If specified, both \code{GADSdat} are ordered according to \code{ID} before comparing their data.}

\item{metaExceptions}{Should certain meta data columns be excluded from the comparison?}

\item{tolerance}{A numeric value greater than or equal to \code{0}. Differences smaller than \code{tolerance} are not reported.
The default value is close to \code{1.5e-8}.}
}
\value{
Returns a list.
}
\description{
Run tests to check whether two \code{GADSdat} objects are (nearly) equal. Variable names, number of rows in the data,
meta data and data differences are checked and reported as a list output.
}
\details{
More detailed checks for individual variables can be performed via \code{\link{inspectDifferences}}
and \code{\link{inspectMetaDifferences}}.
}
