% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rfEAT.R
\name{RFEAT}
\alias{RFEAT}
\title{Random Forest + Efficiency Analysis Trees}
\usage{
RFEAT(data, x, y, numStop = 5, m = 50, s_mtry = "BRM", na.rm = TRUE)
}
\arguments{
\item{data}{\code{data.frame} or \code{matrix} containing the variables in the model.}

\item{x}{Column input indexes in data.}

\item{y}{Column output indexes in data.}

\item{numStop}{Minimum number of observations in a node for a split to be attempted.}

\item{m}{Number of trees to be built.}

\item{s_mtry}{Number of variables randomly sampled as candidates at each split. The available options are:
\itemize{
\item{\code{"BRM"}}: \code{in / 3}
\item{\code{"DEA1"}}: \code{(t.obs / 2) - out}  
\item{\code{"DEA2"}}: \code{(t.obs / 3) - out}
\item{\code{"DEA3"}}: \code{t.obs - 2 * out}
\item{\code{"DEA4"}}: \code{min(t.obs / out, (t.obs / 3) - out)}
\item{Any integer}
}}

\item{na.rm}{\code{logical}. If \code{TRUE}, \code{NA} rows are omitted.}
}
\value{
A \code{RFEAT} object containing:
\itemize{
  \item{\code{data} \itemize{
                      \item{\code{df}}: data frame containing the variables in the model.
                      \item{\code{x}}: input indexes in data.
                      \item{\code{y}}: output indexes in data.
                      \item{\code{input_names}}: input variable names.
                      \item{\code{output_names}}: output variable names.
                      \item{\code{row_names}}: rownames in data.}
       }
  \item{\code{control} \itemize{
                        \item{\code{numStop}}: numStop hyperparameter value.
                        \item{\code{m}}: m hyperparameter value.
                        \item{\code{s_mtry}}: s_mtry hyperparameter value.
                        \item{\code{na.rm}}: na.rm hyperparameter value.}
       }
  \item{\code{forest}: list structure containing the individual EAT models.}
  \item{\code{error}: Out-of-Bag error at the forest.}   
  \item{\code{OOB}: list containing Out-of-Bag set for each tree.}
}
}
\description{
This function builds \code{m} individual Efficiency Analysis Trees in a forest structure.
}
\examples{
\donttest{
simulated <- X2Y2.sim(N = 50, border = 0.1)

RFmodel <- RFEAT(data = simulated, x = c(1,2), y = c(3, 4), numStop = 5,
                  m = 50, s_mtry = "BRM", na.rm = TRUE)
}

}
