% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cens_get.R
\name{cens_get_dec}
\alias{cens_get_dec}
\alias{cens_get_acs}
\alias{cens_get_raw}
\alias{cens_get}
\title{Download data from a decennial census or ACS table}
\usage{
cens_get_dec(
  table,
  geo = NULL,
  ...,
  sumfile = "sf1",
  pop_group = NULL,
  check_geo = FALSE,
  drop_total = FALSE,
  show_call = FALSE
)

cens_get_acs(
  table,
  geo = NULL,
  ...,
  year = 2019,
  survey = c("acs5", "acs1"),
  check_geo = FALSE,
  drop_total = FALSE,
  show_call = FALSE
)

cens_get_raw(
  table,
  geo = NULL,
  ...,
  year = 2010,
  api = NULL,
  check_geo = FALSE,
  show_call = TRUE
)
}
\arguments{
\item{table}{The table to download, either as a character vector or a table
object as produced by \code{\link[=cens_find_dec]{cens_find_dec()}},  \code{\link[=cens_find_acs]{cens_find_acs()}} or
\code{\link[=cens_parse_tables]{cens_parse_tables()}}, or as included in \code{tables_dec} and \code{tables_acs}.
Note: some tables are split into A/B/C/etc. versions by race; this function
unifies all of these tables under one code. So, for example, use \code{P012},
not \code{P012A}.}

\item{geo}{The geographic level to return. One of the machine-readable or
human-readable names listed in the "Details" section of \code{\link[=cens_geo]{cens_geo()}}. Will
return all matching geographies of this level, as filtered by the further
arguments to \code{...}.  For example, setting \code{geo="tract"} is equivalent to
setting \code{tract="all"}.}

\item{...}{Geographies to return, as supported by the Census API. Order
matters here---the first argument will be the geographic level to return
(i.e., it corresponds to the \code{geo} argument) and additional arguments will
filter the results. Use \code{"all"}, \code{"*"}, \code{NA}, or \code{TRUE} to return all units
of a particular geography.  See the examples of \code{\link[=cens_geo]{cens_geo()}} for details.}

\item{sumfile}{For decennial data, the summary file to use. SF2 contains more
detailed race and household info.}

\item{pop_group}{For decennial data using summary file SF2, the population
group to filter to. See
\url{https://www2.census.gov/programs-surveys/decennial/2010/technical-documentation/complete-tech-docs/summary-file/sf2.pdf#page=347}.}

\item{check_geo}{If \code{TRUE}, validate the provided geographies against the
available geographies from the relevant Census API.}

\item{drop_total}{Whether to filter out variables which are totals across
another variable. Recommended only after inspection of the underlying
table.}

\item{show_call}{Whether to show the actual call to the Census API. May be
useful for debugging.}

\item{year}{For ACS data, the survey year to get data for.}

\item{survey}{For ACS data, whether to use the one-year or
five-year survey (the default). Make sure to check availability using
\code{\link[=cens_find_acs]{cens_find_acs()}}.}

\item{api}{A Census API programmatic name such as \code{"acs/acs5"}.}
}
\value{
A tibble of census data in tidy format, with columns
\code{GEOID}, \code{NAME}, \code{variable} (containing the Census variable code),
\code{value} or \code{estimate} in the case of ACS tables,
and additional factor columns specific to the table.
}
\description{
Leverages \code{\link[censusapi:getCensus]{censusapi::getCensus()}} to download tables of census data. Tables
are returned in tidy format, with variables given tidy, human-readable names.
}
\section{Functions}{
\itemize{
\item \code{cens_get_dec()}: Get decennial census data.

\item \code{cens_get_acs()}: Get American Community Survey (ACS) data.

\item \code{cens_get_raw()}: Get raw data from another Census Bureau API. Output will
be minimally tidied but will likely require further manipulation.

}}
\examples{
\dontrun{
cens_get_dec("P3", "state")
cens_get_dec(tables_sf1$H2, "state")
cens_get_dec("H2", "county", state="WA", drop_total=TRUE)

cens_get_acs("B09001", county="King", state="WA")
}

}
