% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/easyPubMed_scr.R
\name{custom_grep}
\alias{custom_grep}
\title{Retrieve Text Between XML Tags}
\usage{
custom_grep(xml_data, tag, format = "list")
}
\arguments{
\item{xml_data}{String (of class character and length 1): corresponds to the PubMed 
record or any string including XML/HTML tags.}

\item{tag}{String (of class character and length 1): the tag of interest (does NOT include < > chars).}

\item{format}{c("list", "char"): specifies the format for the output.}
}
\value{
List or vector where each element corresponds to an in-tag substring.
}
\description{
Extract text form a string containing XML or HTML tags. Text 
included between tags of interest will be returned. If multiple tagged substrings are found, 
they will be returned as different elements of a list or character vector.
}
\details{
The input string has to be a character string (length 1) containing tags (HTML or XML format). 
If an XML Document is provided as input, the function will rise an error.
}
\examples{
try({
  ## extract substrings based on regular expressions
  string_01 <- "I can't wait to watch the <strong>Late Night Show with" 
  string_01 <- paste(string_01, "Seth Meyers</strong> tonight at <strong>11:30</strong>pm CT!")
  print(string_01)
  custom_grep(xml_data = string_01, tag = "strong", format = "char")
  custom_grep(xml_data = string_01, tag = "strong", format = "list")
}, silent = TRUE)

}
\references{
\url{https://www.data-pulse.com/dev_site/easypubmed/}
}
\author{
Damiano Fantini \email{damiano.fantini@gmail.com}
}
