% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.R
\name{checkAlignedDims}
\alias{checkAlignedDims}
\title{Check whether some dimensions of two arrays are aligned}
\usage{
checkAlignedDims(
  incoming,
  reference,
  align.dims,
  in.name = NULL,
  ref.name = NULL,
  withDimnames = FALSE
)
}
\arguments{
\item{incoming}{The array-like object to check}

\item{reference}{The array-like object to be aligned with}

\item{align.dims}{A integer vector indicating which dimensions of
\code{reference} should be used for alignment. The length must be equal to
the dimension numbers of \code{incoming}}

\item{in.name}{The name of \code{incoming}. Only use for verbose.}

\item{ref.name}{The name of \code{reference}. Only use for verbose.}

\item{withDimnames}{Logical. Whether to also align the dimension names.}
}
\value{
If any dimension is not aligned, raise an error.
}
\description{
Check whether some dimensions of two arrays are aligned
}
\details{
Some examples for \code{align.dims}:
\itemize{
\item \code{c(1, 1)}: The dim[1] of \code{incoming} must align with the
dim[1] of \code{reference}, and the dim[2] of \code{incoming} must align with
the dim[1] of \code{reference}.
\item \code{c(2, 1)}: The dim[1] of \code{incoming} must align with the
dim[2] of \code{reference}, and the dim[2] of \code{incoming} must align with
the dim[1] of \code{reference}.
\item \code{c(NA, 1)}: The dim[1] of \code{incoming} doesn't need to align
with any dimension of \code{reference}, but the dim[2] of \code{incoming}
must align with the dim[1] of \code{reference}.
\item \code{c(2, NA)}: The dim[1] of \code{incoming} must align with the
dim[2] of \code{reference}, but the dim[2] of \code{incoming} doesn't need to
align with any dimension of \code{reference}.
}
}
\examples{

# Get some expression matrices ----
exp1 <- matrix(0, 10, 20)
colnames(exp1) <- paste0("cell_", 1:ncol(exp1))
rownames(exp1) <- paste0("gene_", 1:nrow(exp1))

exp2 <- matrix(0, 10, 15)
colnames(exp2) <- paste0("cell_", 1:ncol(exp2))
rownames(exp2) <- paste0("gene_", 1:nrow(exp2))

exp3 <- matrix(0, 10, 20)
colnames(exp3) <- paste0("c_", 1:ncol(exp3))
rownames(exp3) <- paste0("g_", 1:nrow(exp3))

# Get some PCA embbeding matrices ----
pca1 <- matrix(0, 10, 5)
rownames(pca1) <- paste0("cell_", 1:nrow(pca1))
colnames(pca1) <- paste0("PC_", 1:ncol(pca1))

pca2 <- matrix(0, 20, 5)
rownames(pca2) <- paste0("cell_", 1:nrow(pca2))
colnames(pca2) <- paste0("PC_", 1:ncol(pca2))

pca3 <- matrix(0, 20, 5)
rownames(pca3) <- paste0("c_", 1:nrow(pca3))
colnames(pca3) <- paste0("PC_", 1:ncol(pca3))

# Error: The Dim 2 of exp1 is not aligned with the Dim 2 of exp2!
try(checkAlignedDims(exp2, exp1, c(1, 2)))

checkAlignedDims(exp3, exp1, c(1, 2))

# Error: The Dim 1 of exp3 is not aligned with the Dim 1 of exp1!
try(checkAlignedDims(exp3, exp1, c(1, 2), withDimnames = TRUE))

checkAlignedDims(exp3, exp1, c(NA, 2)) # Don't check the rows of exp3

# Error: The Dim 2 of exp3 is not aligned with the Dim 2 of exp1!
try(checkAlignedDims(exp3, exp1, c(NA, 2), withDimnames = TRUE))

# Error: The Dim 1 of pca1 is not aligned with the Dim 2 of exp1!
# Don't check the columns of pca1
try(checkAlignedDims(pca1, exp1, c(2, NA)))

checkAlignedDims(pca2, exp1, c(2, NA))
checkAlignedDims(pca2, exp1, c(2, NA), withDimnames = TRUE)
checkAlignedDims(pca3, exp1, c(2, NA))

# Error: The Dim 1 of pca3 is not aligned with the Dim 2 of exp1!
try(checkAlignedDims(pca3, exp1, c(2, NA), withDimnames = TRUE))


}
