% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/factor_ops.R
\name{unlistMap}
\alias{unlistMap}
\title{Unlist a mapping list into a named vector}
\usage{
unlistMap(map, keep.unique = TRUE)
}
\arguments{
\item{map}{A named list. Each element must be a vector.}

\item{keep.unique}{Whether or not to remove elements with duplicated names
from the output vector.}
}
\value{
A named vector whose names are original values in \code{map}, and elements
are keys of \code{map}
}
\description{
Function to unlist a one-to-one or one-to-many 'key-value' \code{list} into
a named \code{vector}. Useful for batched replacement of vector elements.
}
\examples{
map <- list(X = c("a", "b"), Y = c("c", "d"))
unlistMap(map)

map <- list(X = c("a", "b", "c"), Y = c("c", "d"))
unlistMap(map)
unlistMap(map, keep.unique = FALSE)

}
