% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_rt.R
\name{plot_rt}
\alias{plot_rt}
\title{Plot reaction time distributions}
\usage{
plot_rt(simulated_output, observed_df, facet_x = c("item_idx"), facet_y = c())
}
\arguments{
\item{simulated_output}{Output from \code{\link{run_simulation}} containing
posterior predictions}

\item{observed_df}{Your observed data as a data frame}

\item{facet_x}{Variables to split plots horizontally. Default is \code{"item_idx"}
to show separate plots for each item}

\item{facet_y}{Variables to split plots vertically. Default is none (\code{c()})}
}
\value{
A plot showing predicted RT distributions (blue), with observed data (red) if provided
}
\description{
Visualize reaction time distributions from your model predictions.
Overlay observed experimental data for reference.
}
\examples{
# Load example posterior simulation output
post_output_path <- system.file(
  "extdata", "rdm_minimal", "abc", "posterior", "neuralnet",
  package = "eam"
)
post_output <- load_simulation_output(post_output_path)

# Load example observed data
obs_file <- system.file(
  "extdata", "rdm_minimal", "observation", "observation_data.csv",
  package = "eam"
)
obs_df <- read.csv(obs_file)

# Plot RT distributions by item
plot_rt(post_output, obs_df, facet_x = c("item_idx"))

# Plot RT distributions by item and group
plot_rt(
  post_output,
  obs_df,
  facet_x = c("item_idx"),
  facet_y = c("group")
)

}
