% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method_create_ti_method_container.R
\name{create_ti_method_container}
\alias{create_ti_method_container}
\title{Create a TI method from a docker / singularity container}
\usage{
create_ti_method_container(
  container_id,
  pull_if_needed = TRUE,
  return_function = TRUE
)
}
\arguments{
\item{container_id}{The name of the container repository (e.g. \code{"dynverse/ti_angle"}).}

\item{pull_if_needed}{Pull the container if not yet available.}

\item{return_function}{Whether to return a function that allows you to override the default parameters, or just return the method meta data as is.}
}
\value{
A function that can be used to adapt the parameters of the method. This functions returns a list containing all metadata of the method, and can be used to \link[=infer_trajectory]{infer a trajectory}
}
\description{
These functions create a TI method from a container using \code{babelwhale}. Supports both docker and singularity as a backend. See \href{../doc/create_ti_method_container.html}{\code{vignette("create_ti_method_container", "dynwrap")}} for a tutorial on how to create a containerized TI method.
}
\examples{
library(babelwhale)

# only run if docker works on this platform
if (test_docker_installation()) {
  method <- create_ti_method_container("dynverse/ti_angle")
  trajectory <- infer_trajectory(example_dataset, method())
}

}
\seealso{
vignette("create_ti_method_container", "dynwrap")
}
\keyword{create_ti_method}
