% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynrCook.R
\name{dynr.cook}
\alias{dynr.cook}
\title{Cook a dynr model to estimate its free parameters}
\usage{
dynr.cook(dynrModel, conf.level = 0.95, infile, optimization_flag = TRUE,
  hessian_flag = TRUE, verbose = TRUE, weight_flag = FALSE,
  debug_flag = FALSE)
}
\arguments{
\item{dynrModel}{a dynr model compiled using dynr.model, consisting of recipes for submodels, 
starting values, parameter names, and C code for each submodel}

\item{conf.level}{a cumulative proportion indicating the level of desired confidence intervals for
the final parameter estimates (default is .95)}

\item{infile}{(not required for models specified through the recipe functions) the name of a file 
that has the C codes for all dynr submodels for those interested in specifying a model directly in C}

\item{optimization_flag}{a flag (TRUE/FALSE) indicating whether optimization is to be done.}

\item{hessian_flag}{a flag (TRUE/FALSE) indicating whether the Hessian matrix is to be calculated.}

\item{verbose}{a flag (TRUE/FALSE) indicating whether more detailed intermediate output during the 
estimation process should be printed}

\item{weight_flag}{a flag (TRUE/FALSE) indicating whether the negative log likelihood function should 
be weighted by the length of the time series for each individual}

\item{debug_flag}{a flag (TRUE/FALSE) indicating whether users want additional dynr output that can 
be used for diagnostic purposes}
}
\description{
Cook a dynr model to estimate its free parameters
}
\details{
Free parameter estimation uses the SLSQP routine from NLOPT.

The typical items returned in the cooked model are the filtered and smoothed latent variable estimates. 
\code{eta_smooth_final}, \code{error_cov_smooth_final} and \code{pr_t_given_T} are respectively 
time-varying smoothed latent variable mean estimates, smoothed error covariance estimates, 
and smoothed regime probability. 
\code{eta_filtered}, \code{error_cov_filtered} and \code{pr_t_given_t} are respectively 
time-varying filtered latent variable mean estimates, filtered error covariance matrix estimates, 
and filtered regime probability.

When \code{debug_flag} is TRUE, then additional information is passed into the cooked model. 
\code{eta_predicted}, \code{error_cov_predicted}, \code{innov_vec}, and \code{residual_cov} are respectively 
time-varying predicted latent variable mean estimates, predicted error covariance matrix estimates, the error/residual estimates (innovation vector),
and the error/residual covariance matrix estimates.
}
\examples{
#fitted.model <- dynr.cook(model)
}
\seealso{
\code{\link{autoplot}}, \code{\link{coef}}, \code{\link{confint}},
\code{\link{deviance}}, \code{\link{initialize}}, \code{\link{logLik}},
\code{\link{names}}, \code{\link{nobs}}, \code{\link{plot}}, \code{\link{print}},
\code{\link{show}}, \code{\link{summary}}, \code{\link{vcov}}.
}

