\name{cauimp}
\alias{cauimp}

\title{Computes Causal Inference through Counterfactual Predictions from a Mixture Estimation with State-Space Components.}

\description{
This function estimates causal inference through counterfactual predictions from a mixture estimation with state-space components. Multi-step ahead predictions are generated by the Monte Carlo method. 
}

\usage{
cauimp(object,x.post,y.post,alpha=0.05,n.sim=100)
}

\arguments{
\item{object}{object of class {\code{mixest}} obtained from {\code{\link[dynmix]{mixest1}}} for the pre-intervention period}
\item{x.post}{{\code{\link[base]{matrix}}} of independent time-series (predictors) for the post-intervention period, observations inserted rowwise}
\item{y.post}{one column {\code{\link[base]{matrix}}} of the post-intervention period observed dependent time-series, observations inserted rowwise}
\item{alpha}{optional, \code{\link[base]{numeric}} between 0 and 1, the desired tail area probability for posterior intervals, by default \code{alpha=0.05} is taken}
\item{n.sim}{optional, \code{\link[base]{numeric}}, number of the post-intervention period simulations, by default \code{n.sim=100} is taken}
}

\value{{\code{\link[base]{list}}} of 
\item{$statistics}{{\code{\link[base]{matrix}}} of summary statistics for the post-intervention period}
\item{$significance}{{\code{\link[base]{logical}}} indicating whether the posterior interval excludes zero}
\item{$p}{{\code{\link[base]{numeric}}} of Bayesian one-sided tail area probability that the observed effect was obtained by chance}
\item{$y.hat}{{\code{\link[base]{vector}}} of the dependent variable predicted for the post-intervention period}
\item{$alpha}{{\code{\link[base]{numeric}}} of the desired tail area probability for posterior intervals, as above}
\item{$n.sim}{{\code{\link[base]{numeric}}} of the number of the post-intervention period simulations, as above}
\item{$y.sim}{{\code{\link[base]{matrix}}} of the simulated dependent variable predictions for the post-intervention period}
}

\examples{
\donttest{
data(oil)
m1 <- mixest1(y=oil[1:300,1,drop=FALSE],x=oil[1:300,-1,drop=FALSE],ftype=0,V=1,W=1,kappa=0.97)
x.1 <- oil[301:323,-1,drop=FALSE]
y.1 <- oil[301:323,1,drop=FALSE]
ci <- cauimp(object=m1,x.post=x.1,y.post=y.1,alpha=0.05,n.sim=100)
}
}

\references{
Brodersen, K. H., Gallusser, F., Koehler, J., Remy, N., Scott, S. L., 2015, Inferring causal impact using Bayesian structural time-series models. \emph{Annals of Applied Statistics} \bold{9}, 247--274.

Morgan, S. L., Winship, C., 2007, \emph{Counterfactuals and Causal Inference}, Cambridge University Press. 
}

\seealso{\code{\link[dynmix]{mixest1}}, \code{\link[CausalImpact]{CausalImpact}}}
