% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynfrail_arguments.R
\name{dynfrail_dist}
\alias{dynfrail_dist}
\title{Distribution parameters for dynfrail}
\usage{
dynfrail_dist(dist = "gamma", theta = 2, pvfm = -1/2, lambda = 0.1,
  n_ints = NULL, times = NULL)
}
\arguments{
\item{dist}{One of 'gamma', 'stable' or 'pvf'.}

\item{theta}{Frailty distribution parameter. Must be >0.}

\item{pvfm}{Only relevant if \code{dist = 'pvf'} is used. It determines which PVF distribution should be used. Must be larger than -1 and not equal to 0.}

\item{lambda}{Frailty autocorrelation parameter. Must be >0.}

\item{n_ints}{For piece-wise constant frailty, the number of intervals. With \code{n_ints = 0}, the classical shared frailty scenario is obtained.}

\item{times}{A vector of time points which determine the piecewise-constant interval for the frailty. Overrides \code{n_ints}.}
}
\value{
An object of the type \code{dynfrail_dist}, which is mostly used to denote the
supported frailty distributions in a consistent way.
}
\description{
Distribution parameters for dynfrail
}
\details{
The \code{theta} and \code{lambda} arguments must be positive. In the case of gamma or PVF, \code{theta} is the inverse of
 the frailty variance, i.e. the larger the \code{theta} is,
 the closer the model is to a Cox model. When \code{dist = "pvf"} and \code{pvfm = -0.5}, the inverse Gaussian
 distribution is obtained.
 For the positive stable distribution, the \eqn{\gamma} parameter of the Laplace transform is
 \eqn{\theta / (1 + \theta)}, with the \eqn{alpha} parameter fixed to 1.
}
\examples{
dynfrail_dist()
# Compound Poisson distribution:
dynfrail_dist(dist = 'pvf', theta = 1.5, pvfm = 0.5)
# Inverse Gaussian distribution:
dynfrail_dist(dist = 'pvf')
}
\seealso{
\code{\link{dynfrail}, \link{dynfrail_control}}
}
