% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loo.R
\name{loo.dynamitefit}
\alias{loo.dynamitefit}
\alias{loo}
\title{Approximate Leave-One-Out (LOO) Cross-validation}
\usage{
\method{loo}{dynamitefit}(x, separate_channels = FALSE, ...)
}
\arguments{
\item{x}{[\code{dynamitefit}]\cr The model fit object.}

\item{separate_channels}{[\code{logical(1)}]\cr If \code{TRUE}, computes LOO
separately for each channel. This can be useful in diagnosing where the
model fails. Default is \code{FALSE}, in which case the likelihoods of
different channels are combined, i.e., all channels of are left out.}

\item{...}{Ignored.}
}
\value{
An output from \code{\link[loo:loo]{loo::loo()}} or a list of such outputs (if
\code{separate_channels} was \code{TRUE}).
}
\description{
Estimates the leave-one-out (LOO) information criterion for \code{dynamite}
models using Pareto smoothed importance sampling with the \code{loo} package.
}
\examples{
\donttest{
# this gives warnings due to the small number of iterations
suppressWarnings(loo(gaussian_example_fit))
suppressWarnings(loo(gaussian_example_fit, separate_channels = TRUE))
}

}
