/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.lafwidget.utils;

import java.awt.Component;
import java.awt.Container;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.jvnet.lafwidget.LafWidgetUtilities;
import org.jvnet.lafwidget.utils.FadeAccelerationStep;
import org.jvnet.lafwidget.utils.FadeConfigurationManager;
import org.jvnet.lafwidget.utils.FadeStep;
import org.jvnet.lafwidget.utils.LafConstants;
import org.jvnet.lafwidget.utils.TrackableThread;

public class FadeTracker {
    public static final int END_VALUE = 10;
    private static FadeTracker instance;
    private Map trackedComponents;
    private Map fadeInstances;
    private FadeTrackerThread trackerThread = this.getThread();

    private FadeTracker() {
        this.trackedComponents = new HashMap();
        this.fadeInstances = new HashMap();
    }

    public static synchronized FadeTracker getInstance() {
        if (instance == null) {
            instance = new FadeTracker();
        }
        return instance;
    }

    private synchronized void updateComponents() {
        HashSet<Container> parents = new HashSet<Container>();
        Iterator itComp = this.trackedComponents.entrySet().iterator();
        while (itComp.hasNext()) {
            Map.Entry entry = itComp.next();
            ComponentId compId = (ComponentId)entry.getKey();
            Map mapComp = (Map)entry.getValue();
            Iterator itKind = mapComp.entrySet().iterator();
            while (itKind.hasNext()) {
                Map.Entry entryKind = itKind.next();
                FadeState state = (FadeState)entryKind.getValue();
                boolean hasEnded = false;
                if (state.isFadingIn) {
                    state.fadePosition += state.fadeStep.getNextStep(state.fadeKind, state.fadePosition, state.isFadingIn, state.isLooping);
                    if (state.fadePosition > 10.0f) {
                        state.fadePosition = 10.0f;
                        if (state.isLooping) {
                            if (state.isLoopingReverse) {
                                state.isFadingIn = false;
                            } else {
                                state.fadePosition = 0.0f;
                                if (state.toStopAtCycleBreak) {
                                    this.fadeInstances.remove(new Long(state.id));
                                    hasEnded = true;
                                    itKind.remove();
                                }
                            }
                        } else {
                            this.fadeInstances.remove(new Long(state.id));
                            hasEnded = true;
                            itKind.remove();
                        }
                    }
                } else {
                    state.fadePosition -= state.fadeStep.getNextStep(state.fadeKind, state.fadePosition, state.isFadingIn, state.isLooping);
                    if (state.fadePosition < 0.0f) {
                        if (state.isLooping && !state.toStopAtCycleBreak) {
                            state.fadePosition = 0.0f;
                            state.isFadingIn = true;
                        } else {
                            this.fadeInstances.remove(new Long(state.id));
                            hasEnded = true;
                            itKind.remove();
                        }
                    }
                }
                if (!compId.component.isDisplayable()) continue;
                if (state.callback != null) {
                    if (hasEnded) {
                        state.callback.fadeEnded(state.fadeKind);
                        continue;
                    }
                    state.callback.fadePerformed(state.fadeKind, state.fadePosition);
                    continue;
                }
                if (state.toRepaintParent) {
                    parents.add(compId.component.getParent());
                    continue;
                }
                compId.component.repaint();
            }
            if (mapComp.size() != 0) continue;
            itComp.remove();
        }
        for (Component component : parents) {
            component.repaint();
        }
    }

    private synchronized FadeState getState(FadeKind fadeKind, Component comp, Comparable componentId) {
        ComponentId cid = new ComponentId(comp, componentId);
        HashMap map = (HashMap)this.trackedComponents.get(cid);
        if (map == null) {
            map = new HashMap();
            this.trackedComponents.put(cid, map);
        }
        return (FadeState)map.get(fadeKind);
    }

    private synchronized void addState(Component comp, Comparable componentId, FadeKind fadeKind, FadeState fadeState) {
        ComponentId cid = new ComponentId(comp, componentId);
        HashMap<FadeKind, FadeState> map = (HashMap<FadeKind, FadeState>)this.trackedComponents.get(cid);
        if (map == null) {
            map = new HashMap<FadeKind, FadeState>();
            this.trackedComponents.put(cid, map);
        }
        map.put(fadeKind, fadeState);
        this.fadeInstances.put(new Long(fadeState.id), cid);
    }

    public synchronized long trackFadeIn(FadeKind fadeKind, Component comp, boolean toRepaintParent, FadeTrackerCallback callback) {
        return this.trackFadeIn(fadeKind, comp, null, toRepaintParent, callback);
    }

    public synchronized long trackFadeIn(FadeKind fadeKind, Component comp, int componentId, boolean toRepaintParent, FadeTrackerCallback callback) {
        return this.trackFadeIn(fadeKind, comp, new Integer(componentId), toRepaintParent, callback);
    }

    public synchronized long trackFadeIn(FadeKind fadeKind, Component comp, Comparable componentId, boolean toRepaintParent, FadeTrackerCallback callback) {
        return this.trackFadeIn(fadeKind, comp, componentId, toRepaintParent, callback, LafWidgetUtilities.getAnimationKind(comp));
    }

    public synchronized long trackFadeIn(FadeKind fadeKind, Component comp, Comparable componentId, boolean toRepaintParent, FadeTrackerCallback callback, LafConstants.AnimationKind aKind) {
        if (!comp.isDisplayable()) {
            return -1L;
        }
        if (LafWidgetUtilities.hasNoFades(comp, fadeKind)) {
            if (callback != null) {
                callback.fadeEnded(fadeKind);
            } else if (toRepaintParent && comp.getParent() != null) {
                comp.getParent().repaint();
            } else {
                comp.repaint();
            }
            return -1L;
        }
        this.getThread();
        FadeState fadeState = this.getState(fadeKind, comp, componentId);
        if (fadeState == null) {
            fadeState = new FadeState(fadeKind, 0.0f, true, toRepaintParent);
            fadeState.fadeStep = aKind.getStep();
            if (fadeKind == FadeKind.SELECTION) {
                fadeState.fadeStep = new FadeAccelerationStep(fadeState.fadeStep, 2.0f);
            }
            this.addState(comp, componentId, fadeKind, fadeState);
        } else {
            fadeState.isFadingIn = true;
        }
        fadeState.callback = callback;
        return fadeState.id;
    }

    public synchronized long trackFadeOut(FadeKind fadeKind, Component comp, boolean toRepaintParent, FadeTrackerCallback callback) {
        return this.trackFadeOut(fadeKind, comp, null, toRepaintParent, callback);
    }

    public synchronized long trackFadeOut(FadeKind fadeKind, Component comp, int componentId, boolean toRepaintParent, FadeTrackerCallback callback) {
        return this.trackFadeOut(fadeKind, comp, new Integer(componentId), toRepaintParent, callback);
    }

    public synchronized long trackFadeOut(FadeKind fadeKind, Component comp, Comparable componentId, boolean toRepaintParent, FadeTrackerCallback callback) {
        return this.trackFadeOut(fadeKind, comp, componentId, toRepaintParent, callback, LafWidgetUtilities.getAnimationKind(comp));
    }

    public synchronized long trackFadeOut(FadeKind fadeKind, Component comp, Comparable componentId, boolean toRepaintParent, FadeTrackerCallback callback, LafConstants.AnimationKind aKind) {
        if (!comp.isDisplayable()) {
            return -1L;
        }
        if (LafWidgetUtilities.hasNoFades(comp, fadeKind)) {
            if (callback != null) {
                callback.fadeEnded(fadeKind);
            } else if (toRepaintParent && comp.getParent() != null) {
                comp.getParent().repaint();
            } else {
                comp.repaint();
            }
            return -1L;
        }
        this.getThread();
        FadeState fadeState = this.getState(fadeKind, comp, componentId);
        if (fadeState == null) {
            fadeState = new FadeState(fadeKind, 10.0f, false, toRepaintParent);
            fadeState.fadeStep = aKind.getStep();
            if (fadeKind == FadeKind.SELECTION) {
                fadeState.fadeStep = new FadeAccelerationStep(fadeState.fadeStep, 2.0f);
            }
            this.addState(comp, componentId, fadeKind, fadeState);
        } else {
            fadeState.isFadingIn = false;
        }
        fadeState.callback = callback;
        return fadeState.id;
    }

    public synchronized long trackFade(Component comp, FadeKind fadeKind, boolean isFadeIn, boolean toRepaintParent) {
        return this.trackFade(comp, fadeKind, isFadeIn, toRepaintParent, null);
    }

    public synchronized long trackFade(Component comp, FadeKind fadeKind, boolean isFadeIn, boolean toRepaintParent, FadeTrackerCallback callback) {
        if (isFadeIn) {
            return this.trackFadeIn(fadeKind, comp, toRepaintParent, callback);
        }
        return this.trackFadeOut(fadeKind, comp, toRepaintParent, callback);
    }

    public synchronized long trackFadeLooping(FadeKind fadeKind, LafConstants.AnimationKind animationKind, Component comp, Comparable componentId, boolean toRepaintParent, FadeTrackerCallback callback, boolean isLoopingReverse) {
        this.getThread();
        if (LafWidgetUtilities.hasNoFades(comp, fadeKind)) {
            if (callback != null) {
                callback.fadeEnded(fadeKind);
            } else if (toRepaintParent && comp.getParent() != null) {
                comp.getParent().repaint();
            } else {
                comp.repaint();
            }
            return -1L;
        }
        FadeState fadeState = this.getState(fadeKind, comp, componentId);
        if (fadeState == null) {
            fadeState = new FadeState(fadeKind, 0.0f, true, toRepaintParent);
            fadeState.fadeStep = animationKind.getStep();
            fadeState.isLooping = true;
            fadeState.isLoopingReverse = isLoopingReverse;
            this.addState(comp, componentId, fadeKind, fadeState);
        } else {
            fadeState.isLooping = true;
            fadeState.isLoopingReverse = isLoopingReverse;
        }
        fadeState.callback = callback;
        return fadeState.id;
    }

    public boolean isTracked(Component comp, FadeKind fadeKind) {
        return this.isTracked(comp, null, fadeKind);
    }

    public boolean isTracked(Component comp, int componentId, FadeKind fadeKind) {
        return this.isTracked(comp, new Integer(componentId), fadeKind);
    }

    public boolean isTracked(Component comp, Comparable componentId, FadeKind fadeKind) {
        ComponentId cid = new ComponentId(comp, componentId);
        Map map = (Map)this.trackedComponents.get(cid);
        if (map == null) {
            return false;
        }
        if (fadeKind == null) {
            return map.size() > 0;
        }
        return map.containsKey(fadeKind);
    }

    public boolean isTracked(Component comp, Comparable componentId, FadeKind fadeKind, boolean checkFadeIn) {
        ComponentId cid = new ComponentId(comp, componentId);
        Map map = (Map)this.trackedComponents.get(cid);
        if (map == null) {
            return false;
        }
        if (fadeKind == null) {
            for (FadeState fadeState : map.entrySet()) {
                if (fadeState.isFadingIn != checkFadeIn) continue;
                return true;
            }
            return false;
        }
        FadeState fState = (FadeState)map.get(fadeKind);
        if (fState == null) {
            return false;
        }
        return fState.isFadingIn == checkFadeIn;
    }

    public synchronized float getFade10(Component comp, FadeKind fadeKind) {
        return this.getFade10(comp, null, fadeKind);
    }

    public synchronized float getFade10(Component comp, int componentId, FadeKind fadeKind) {
        return this.getFade10(comp, new Integer(componentId), fadeKind);
    }

    public synchronized float getFade10(Component comp, Comparable componentId, FadeKind fadeKind) {
        Iterator it;
        ComponentId cid = new ComponentId(comp, componentId);
        Map map = (Map)this.trackedComponents.get(cid);
        if (map == null || map.size() == 0) {
            return 0.0f;
        }
        if (fadeKind == null && (it = map.values().iterator()).hasNext()) {
            FadeState fs = (FadeState)it.next();
            return fs.fadePosition;
        }
        FadeState state = (FadeState)map.get(fadeKind);
        if (state == null) {
            return 0.0f;
        }
        return state.fadePosition;
    }

    public synchronized void stopAllTimers() {
        for (Map.Entry entryComp : this.trackedComponents.entrySet()) {
            Map mapComp = (Map)entryComp.getValue();
            for (Map.Entry entryKind : mapComp.entrySet()) {
                FadeState state = (FadeState)entryKind.getValue();
                if (state.callback == null) continue;
                state.callback.fadeEnded(state.fadeKind);
            }
        }
        this.trackedComponents.clear();
        this.fadeInstances.clear();
    }

    private synchronized FadeTrackerThread getThread() {
        if (this.trackerThread == null) {
            this.trackerThread = new FadeTrackerThread();
            this.trackerThread.start();
        }
        return this.trackerThread;
    }

    public synchronized void cancelFadeInstance(long fadeInstanceId) {
        ComponentId cid = (ComponentId)this.fadeInstances.get(new Long(fadeInstanceId));
        if (cid != null) {
            Map compFades = (Map)this.trackedComponents.get(cid);
            Iterator itKind = compFades.entrySet().iterator();
            while (itKind.hasNext()) {
                Map.Entry entryKind = itKind.next();
                FadeState state = (FadeState)entryKind.getValue();
                if (fadeInstanceId != state.id) continue;
                itKind.remove();
                state.callback.fadeEnded(state.fadeKind);
            }
            if (compFades.size() == 0) {
                this.trackedComponents.remove(cid);
            }
            this.fadeInstances.remove(new Long(fadeInstanceId));
        }
    }

    public synchronized void requestStopOnCycleBreak(long fadeInstanceId) {
        ComponentId cid = (ComponentId)this.fadeInstances.get(new Long(fadeInstanceId));
        if (cid != null) {
            Map compFades = (Map)this.trackedComponents.get(cid);
            for (Map.Entry entryKind : compFades.entrySet()) {
                FadeState state = (FadeState)entryKind.getValue();
                if (fadeInstanceId != state.id) continue;
                state.toStopAtCycleBreak();
            }
        }
    }

    private class FadeTrackerThread
    extends TrackableThread {
        public static final int DELAY = 40;
        private boolean stopRequested;

        public FadeTrackerThread() {
            this.setName("Laf-Widget fade tracker");
            this.stopRequested = false;
        }

        public void run() {
            while (!this.stopRequested) {
                try {
                    Thread.sleep(40L);
                }
                catch (InterruptedException ie) {
                    ie.printStackTrace();
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        FadeTracker.this.updateComponents();
                    }
                });
            }
        }

        protected void requestStop() {
            this.stopRequested = true;
            FadeTracker.this.trackerThread = null;
        }
    }

    private static class FadeState {
        protected static long counter;
        protected long id;
        public float fadePosition;
        public boolean isFadingIn;
        public boolean isLooping;
        public boolean isLoopingReverse;
        public boolean toStopAtCycleBreak;
        public boolean toRepaintParent;
        public FadeTrackerCallback callback;
        public FadeStep fadeStep;
        public FadeKind fadeKind;

        public FadeState(FadeKind fadeKind, float fadePosition, boolean isFadingIn, boolean toRepaintParent) {
            this.fadeKind = fadeKind;
            this.fadePosition = fadePosition;
            this.isFadingIn = isFadingIn;
            this.toRepaintParent = toRepaintParent;
            this.id = FadeState.getId();
            this.isLooping = false;
            this.toStopAtCycleBreak = false;
        }

        public void setLooping(boolean isLooping) {
            this.isLooping = isLooping;
        }

        public void toStopAtCycleBreak() {
            if (!this.isLooping) {
                throw new IllegalArgumentException("Supported only on looping fades");
            }
            this.toStopAtCycleBreak = true;
        }

        protected static synchronized long getId() {
            return counter++;
        }
    }

    public static interface FadeTrackerCallback {
        public void fadePerformed(FadeKind var1, float var2);

        public void fadeEnded(FadeKind var1);
    }

    protected static class ComponentId {
        public Component component;
        public Comparable id;

        public ComponentId(Component component, Comparable id) {
            this.component = component;
            this.id = id;
        }

        public int hashCode() {
            int result = this.component.hashCode();
            if (this.id != null) {
                result &= this.id.hashCode();
            }
            return result;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ComponentId) {
                ComponentId cid = (ComponentId)obj;
                try {
                    boolean result;
                    boolean bl = result = this.component == cid.component;
                    result = this.id == null ? result && cid.id == null : result && this.id.compareTo(cid.id) == 0;
                    return result;
                }
                catch (Exception exc) {
                    return false;
                }
            }
            return false;
        }
    }

    public static class FadeKind {
        protected String id;
        public static final FadeKind ARM = new FadeKind("lafwidgets.core.arm");
        public static final FadeKind PRESS = new FadeKind("lafwidgets.core.press");
        public static final FadeKind FOCUS = new FadeKind("lafwidgets.core.focus");
        public static final FadeKind ENABLE = new FadeKind("lafwidgets.core.enable");
        public static final FadeKind ROLLOVER = new FadeKind("lafwidgets.core.rollover");
        public static final FadeKind SELECTION = new FadeKind("lafwidgets.core.selection");
        public static final FadeKind GHOSTING_ICON_ROLLOVER = new FadeKind("lafwidgets.core.ghosting.iconRollover", false);
        public static final FadeKind GHOSTING_BUTTON_PRESS = new FadeKind("lafwidgets.core.ghosting.buttonPress", false);

        public FadeKind(String id) {
            this(id, true);
        }

        public FadeKind(String id, boolean isDefaultAllowed) {
            this.id = id;
            if (isDefaultAllowed) {
                FadeConfigurationManager.getInstance().allowFades(this);
            }
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof FadeKind) {
                return this.id.equals(((FadeKind)obj).id);
            }
            return false;
        }
    }
}

