/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphics2d;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.awt.print.PrinterGraphics;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.AttributedCharacterIterator;
import java.util.HashMap;
import java.util.Map;
import org.freehep.graphics2d.AbstractVectorGraphics;
import org.freehep.graphics2d.ArrayPath;
import org.freehep.graphics2d.GenericTagHandler;
import org.freehep.graphics2d.VectorGraphics;
import org.freehep.graphics2d.WebColor;
import org.freehep.graphics2d.font.FontEncoder;

public class PixelGraphics2D
extends AbstractVectorGraphics {
    public static final RenderingHints.Key KEY_SYMBOL_BLIT = new SymbolBlitKey();
    public static final Object VALUE_SYMBOL_BLIT_ON = Boolean.TRUE;
    public static final Object VALUE_SYMBOL_BLIT_OFF = Boolean.FALSE;
    protected Graphics2D hostGraphics;
    protected double lineWidth;
    protected int resolution;
    protected GenericTagHandler tagHandler;
    private static final int MAX_BLIT_SIZE = 32;
    private static Map symbols = new HashMap();
    private WebColor webColor;
    private static boolean displayX11 = false;
    private static boolean displayLocal = false;

    public PixelGraphics2D(Graphics graphics) {
        this();
        this.setHostGraphics(graphics);
    }

    protected PixelGraphics2D(PixelGraphics2D graphics) {
        super(graphics);
        this.setHostGraphics(graphics.hostGraphics.create());
    }

    protected PixelGraphics2D() {
    }

    protected void setHostGraphics(Graphics graphics) {
        this.hostGraphics = (Graphics2D)graphics;
        this.resolution = graphics instanceof PrinterGraphics ? 0 : 1;
        this.tagHandler = new GenericTagHandler(this.hostGraphics);
        super.setBackground(this.hostGraphics.getBackground());
        super.setColor(this.hostGraphics.getColor());
        super.setPaint(this.hostGraphics.getPaint());
        super.setFont(this.hostGraphics.getFont());
        Stroke s = this.hostGraphics.getStroke();
        if (s instanceof BasicStroke) {
            this.lineWidth = ((BasicStroke)s).getLineWidth();
        }
        this.webColor = WebColor.create(this.getColor());
        this.setRenderingHint(KEY_SYMBOL_BLIT, VALUE_SYMBOL_BLIT_ON);
    }

    public void startExport() {
    }

    public void endExport() {
    }

    public void printComment(String comment) {
    }

    public Graphics create(double x, double y, double width, double height) {
        PixelGraphics2D graphics = new PixelGraphics2D(this);
        graphics.translate(x, y);
        graphics.clipRect(0.0, 0.0, width, height);
        return graphics;
    }

    public void clearRect(int x, int y, int width, int height) {
        this.hostGraphics.clearRect(x, y, width, height);
    }

    public void clipRect(int x, int y, int width, int height) {
        this.hostGraphics.clipRect(x, y, width, height);
    }

    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
        this.hostGraphics.copyArea(x, y, width, height, dx, dy);
    }

    public Graphics create() {
        return new PixelGraphics2D(this);
    }

    public void dispose() {
        this.hostGraphics.dispose();
    }

    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.hostGraphics.drawArc(x, y, width, height, startAngle, arcAngle);
    }

    public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer) {
        return this.hostGraphics.drawImage(img, x, y, this.getPrintColor(bgcolor), observer);
    }

    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        return this.hostGraphics.drawImage(img, x, y, observer);
    }

    public boolean drawImage(Image img, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
        return this.hostGraphics.drawImage(img, x, y, width, height, this.getPrintColor(bgcolor), observer);
    }

    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        return this.hostGraphics.drawImage(img, x, y, width, height, observer);
    }

    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        return this.hostGraphics.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, this.getPrintColor(bgcolor), observer);
    }

    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        return this.hostGraphics.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, observer);
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        this.hostGraphics.drawLine(x1, y1, x2, y2);
    }

    public void drawOval(int x, int y, int width, int height) {
        this.hostGraphics.drawOval(x, y, width, height);
    }

    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.hostGraphics.drawPolygon(xPoints, yPoints, nPoints);
    }

    public void drawPolygon(Polygon p) {
        this.hostGraphics.drawPolygon(p);
    }

    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        this.hostGraphics.drawPolyline(xPoints, yPoints, nPoints);
    }

    public void drawRect(int x, int y, int width, int height) {
        this.hostGraphics.drawRect(x, y, width, height);
    }

    public void drawString(String str, int x, int y) {
        str = FontEncoder.getEncodedString(str, this.getFont().getName());
        this.hostGraphics.drawString(str, x, y);
    }

    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.hostGraphics.fillArc(x, y, width, height, startAngle, arcAngle);
    }

    public void fillOval(int x, int y, int width, int height) {
        this.hostGraphics.fillOval(x, y, width, height);
    }

    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.hostGraphics.fillPolygon(xPoints, yPoints, nPoints);
    }

    public void fillPolygon(Polygon p) {
        this.hostGraphics.fillPolygon(p);
    }

    public void fillRect(int x, int y, int width, int height) {
        this.hostGraphics.fillRect(x, y, width, height);
    }

    public void drawSymbol(double x, double y, double size, int symbol) {
        if (size <= 0.0) {
            return;
        }
        int intSize = (int)Math.ceil(size);
        if (intSize > 32 || this.lineWidth != 1.0 || !PixelGraphics2D.isDisplayLocal() || this.getRenderingHint(RenderingHints.KEY_ANTIALIASING) == RenderingHints.VALUE_ANTIALIAS_ON || this.getRenderingHint(KEY_SYMBOL_BLIT) == VALUE_SYMBOL_BLIT_OFF) {
            super.drawSymbol(x, y, size, symbol);
            return;
        }
        this.blitSymbol(x, y, intSize, symbol, false);
    }

    public void fillSymbol(double x, double y, double size, int symbol) {
        if (size <= 0.0) {
            return;
        }
        int intSize = (int)Math.ceil(size);
        if (intSize > 32 || this.lineWidth != 1.0 || !PixelGraphics2D.isDisplayLocal() || this.getRenderingHint(RenderingHints.KEY_ANTIALIASING) == RenderingHints.VALUE_ANTIALIAS_ON || this.getRenderingHint(KEY_SYMBOL_BLIT) == VALUE_SYMBOL_BLIT_OFF) {
            super.fillSymbol(x, y, size, symbol);
            return;
        }
        this.blitSymbol(x, y, intSize, symbol, true);
    }

    public void fillAndDrawSymbol(double x, double y, double size, int symbol, Color fillColor) {
        Color color = this.getColor();
        this.setColor(fillColor);
        super.fillSymbol(x, y, size, symbol);
        this.setColor(color);
        super.drawSymbol(x, y, size, symbol);
    }

    private void blitSymbol(double x, double y, int size, int symbol, boolean fill) {
        Image[][][] images = (Image[][][])symbols.get(this.webColor);
        if (images == null) {
            images = new Image[2][10][32];
            symbols.put(this.webColor, images);
        }
        Image image = images[fill ? 1 : 0][symbol][size - 1];
        int imageSize = size + 1;
        double imageSize2 = (double)imageSize / 2.0;
        if (image == null) {
            image = this.getDeviceConfiguration().createCompatibleImage(imageSize + 1, imageSize + 1, 2);
            VectorGraphics imageGraphics = VectorGraphics.create(image.getGraphics());
            Composite composite = imageGraphics.getComposite();
            imageGraphics.setComposite(AlphaComposite.Clear);
            imageGraphics.fillRect(0, 0, size, size);
            imageGraphics.setComposite(composite);
            imageGraphics.setColor(this.getColor());
            if (fill) {
                this.fillSymbol(imageGraphics, imageSize2, imageSize2, size, symbol);
            } else {
                this.drawSymbol(imageGraphics, imageSize2, imageSize2, size, symbol);
            }
            images[fill ? 1 : 0][symbol][size - 1] = image;
        }
        this.drawImage(image, (int)(x - imageSize2), (int)(y - imageSize2), null);
    }

    public void setLineWidth(double width) {
        super.setLineWidth(width);
        this.lineWidth = width;
    }

    public Shape getClip() {
        return this.hostGraphics.getClip();
    }

    public Rectangle getClipBounds() {
        return this.hostGraphics.getClipBounds();
    }

    public Rectangle getClipBounds(Rectangle r) {
        return this.hostGraphics.getClipBounds(r);
    }

    public FontMetrics getFontMetrics(Font f) {
        return this.hostGraphics.getFontMetrics(f);
    }

    public void setClip(int x, int y, int width, int height) {
        this.hostGraphics.setClip(x, y, width, height);
    }

    public void setClip(Shape clip) {
        this.hostGraphics.setClip(clip);
    }

    public void setFont(Font font) {
        if (font == null) {
            return;
        }
        super.setFont(font);
        if (font.getName().equals("Symbol") || font.getName().equals("ZapfDingbats")) {
            Font newFont = new Font("Serif", font.getSize(), font.getStyle());
            font = newFont.deriveFont(font.getSize2D());
        }
        this.hostGraphics.setFont(font);
    }

    public void setColor(Color color) {
        if (color == null) {
            return;
        }
        if (color.equals(this.getColor())) {
            return;
        }
        super.setColor(color);
        this.hostGraphics.setColor(this.getPrintColor(color));
        this.webColor = WebColor.create(color);
    }

    public void setPaint(Paint paint) {
        if (paint == null) {
            return;
        }
        if (paint.equals(this.getPaint())) {
            return;
        }
        if (paint instanceof Color) {
            this.setColor((Color)paint);
        } else {
            super.setPaint(paint);
            this.hostGraphics.setPaint(paint);
        }
    }

    public void setPaintMode() {
        this.hostGraphics.setPaintMode();
    }

    public void setXORMode(Color c1) {
        this.hostGraphics.setXORMode(this.getPrintColor(c1));
    }

    public void translate(int x, int y) {
        this.hostGraphics.translate(x, y);
    }

    public void addRenderingHints(Map hints) {
        this.hostGraphics.addRenderingHints(hints);
    }

    public void clip(Shape clip) {
        this.hostGraphics.clip(clip);
    }

    public void draw(Shape s) {
        this.hostGraphics.draw(s);
    }

    public void drawGlyphVector(GlyphVector g, float x, float y) {
        this.hostGraphics.drawGlyphVector(g, x, y);
    }

    public void drawImage(BufferedImage img, BufferedImageOp op, int x, int y) {
        this.hostGraphics.drawImage(img, op, x, y);
    }

    public boolean drawImage(Image img, AffineTransform xform, ImageObserver obs) {
        return this.hostGraphics.drawImage(img, xform, obs);
    }

    public void drawRenderableImage(RenderableImage img, AffineTransform xform) {
        this.hostGraphics.drawRenderableImage(img, xform);
    }

    public void drawRenderedImage(RenderedImage img, AffineTransform xform) {
        this.hostGraphics.drawRenderedImage(img, xform);
    }

    public void drawString(AttributedCharacterIterator iterator, float x, float y) {
        this.hostGraphics.drawString(iterator, x, y);
    }

    public void drawString(AttributedCharacterIterator iterator, int x, int y) {
        this.hostGraphics.drawString(iterator, x, y);
    }

    public void drawString(String str, float x, float y) {
        str = FontEncoder.getEncodedString(str, this.getFont().getName());
        this.hostGraphics.drawString(str, x, y);
    }

    public void fill(Shape s) {
        this.hostGraphics.fill(s);
    }

    public Composite getComposite() {
        return this.hostGraphics.getComposite();
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        return this.hostGraphics.getDeviceConfiguration();
    }

    public FontRenderContext getFontRenderContext() {
        return this.hostGraphics.getFontRenderContext();
    }

    public Object getRenderingHint(RenderingHints.Key hintKey) {
        return this.hostGraphics.getRenderingHint(hintKey);
    }

    public RenderingHints getRenderingHints() {
        return this.hostGraphics.getRenderingHints();
    }

    public Stroke getStroke() {
        return this.hostGraphics.getStroke();
    }

    public AffineTransform getTransform() {
        return this.hostGraphics.getTransform();
    }

    public boolean hit(Rectangle rect, Shape s, boolean onStroke) {
        return this.hostGraphics.hit(rect, s, onStroke);
    }

    public void rotate(double theta) {
        this.hostGraphics.rotate(theta);
    }

    public void rotate(double theta, double x, double y) {
        this.hostGraphics.rotate(theta, x, y);
    }

    public void scale(double sx, double sy) {
        this.hostGraphics.scale(sx, sy);
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.hostGraphics.setBackground(this.getPrintColor(color));
    }

    public void setComposite(Composite comp) {
        this.hostGraphics.setComposite(comp);
    }

    public void setRenderingHint(RenderingHints.Key hintKey, Object hintValue) {
        this.hostGraphics.setRenderingHint(hintKey, hintValue);
    }

    public void setRenderingHints(Map hints) {
        this.hostGraphics.setRenderingHints(hints);
    }

    public void setStroke(Stroke s) {
        this.hostGraphics.setStroke(s);
    }

    public void setTransform(AffineTransform Tx) {
        this.hostGraphics.setTransform(Tx);
    }

    public void shear(double shx, double shy) {
        this.hostGraphics.shear(shx, shy);
    }

    public void transform(AffineTransform Tx) {
        this.hostGraphics.transform(Tx);
    }

    public void translate(double tx, double ty) {
        this.hostGraphics.translate(tx, ty);
    }

    public void clearRect(double x, double y, double width, double height) {
        this.clearRect((int)x, (int)y, (int)width, (int)height);
    }

    public void clipRect(double x, double y, double width, double height) {
        this.clipRect((int)x, (int)y, (int)width, (int)height);
    }

    public void drawString(String str, double x, double y) {
        this.drawString(str, (int)Math.round(x), (int)Math.round(y));
    }

    public void setClip(double x, double y, double width, double height) {
        this.setClip(new Rectangle2D.Double(x, y, width, height));
    }

    public String toString() {
        return "PixelGraphics2D[" + this.hostGraphics.toString() + "]";
    }

    public static boolean isDisplayX11() {
        return displayX11;
    }

    public static boolean isDisplayLocal() {
        return displayLocal;
    }

    protected Shape createShape(double[] xPoints, double[] yPoints, int nPoints, boolean close) {
        return new ArrayPath(xPoints, yPoints, nPoints, close, this.resolution);
    }

    static {
        try {
            Class<?> clazz = Class.forName("sun.awt.X11GraphicsEnvironment");
            displayX11 = true;
            Method method = clazz.getMethod("isDisplayLocal", null);
            Boolean result = (Boolean)method.invoke(null, null);
            displayLocal = result;
        }
        catch (ClassNotFoundException e) {
            displayLocal = true;
        }
        catch (IllegalAccessException e) {
        }
        catch (NoSuchMethodException e) {
        }
        catch (InvocationTargetException e) {
        }
        catch (ClassCastException e) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    static class SymbolBlitKey
    extends RenderingHints.Key {
        public SymbolBlitKey() {
            super(94025);
        }

        public boolean isCompatibleValue(Object o) {
            if (o.equals(VALUE_SYMBOL_BLIT_ON)) {
                return true;
            }
            return o.equals(VALUE_SYMBOL_BLIT_OFF);
        }

        public String toString() {
            return "Symbol Blitting enable key";
        }
    }
}

