% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getInvarCompTable.R
\name{getInvarCompTable}
\alias{getInvarCompTable}
\title{Compare model fit of nested dyadic invariance models in order from most parsimonious (residual) to least parsimonious (configural)}
\usage{
getInvarCompTable(mods)
}
\arguments{
\item{mods}{a list of neted lavaan dyadic invariance models, in the order of residual, intercept, loading, configural}
}
\value{
a data frame of model fit statistics for each model, as well as the difference in fit statistics between each model and the previous model
}
\description{
Compare model fit of nested dyadic invariance models in order from most parsimonious (residual) to least parsimonious (configural)
}
\examples{

dvn <- scrapeVarCross(dat = commitmentQ, x_order = "spi",
x_stem = "sat.g", x_delim1 = ".", x_delim2="_", distinguish_1="1", distinguish_2="2")

sat.residual.script <- scriptCFA(dvn, lvname = "Sat",
constr_dy_meas = c("loadings", "intercepts", "residuals"), constr_dy_struct = "none")

sat.intercept.script <- scriptCFA(dvn, lvname = "Sat",
constr_dy_meas = c("loadings", "intercepts"), constr_dy_struct = "none")

sat.loading.script <- scriptCFA(dvn, lvname = "Sat",
constr_dy_meas = c("loadings"), constr_dy_struct = "none")

sat.config.script <- scriptCFA(dvn, lvname = "Sat",
constr_dy_meas = "none", constr_dy_struct = "none")

sat.residual.fit <- lavaan::cfa(sat.residual.script, data = commitmentQ,
std.lv = FALSE, auto.fix.first= FALSE, meanstructure = TRUE)

sat.intercept.fit <- lavaan::cfa(sat.intercept.script, data = commitmentQ,
std.lv = FALSE, auto.fix.first= FALSE, meanstructure = TRUE)

sat.loading.fit <- lavaan::cfa(sat.loading.script, data = commitmentQ,
std.lv = FALSE, auto.fix.first= FALSE, meanstructure = TRUE)

sat.config.fit <- lavaan::cfa(sat.config.script, data = commitmentQ,
std.lv = FALSE, auto.fix.first= FALSE, meanstructure = TRUE)

mods <- list(sat.residual.fit, sat.intercept.fit, sat.loading.fit, sat.config.fit)

getInvarCompTable(mods)

}
