% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fun.R
\name{addCarcass}
\alias{addCarcass}
\alias{addCarcass.shapeCarcass}
\alias{addCarcass.data.frame}
\title{Add Carcasses to a Site Layout}
\usage{
addCarcass(x, ...)

\method{addCarcass}{shapeCarcass}(
  x,
  data_ring,
  plotLayout = NULL,
  ncarcReset = TRUE,
  ccCol = NULL,
  ...
)

\method{addCarcass}{data.frame}(
  x,
  data_ring,
  ccCol = NULL,
  ncarcReset = TRUE,
  unitCol = "turbine",
  rCol = "r",
  ...
)
}
\arguments{
\item{x}{carcass data to insert into \code{data_ring}}

\item{...}{ignored}

\item{data_ring}{ring data for receiving carcass data from \code{x}}

\item{plotLayout}{(optional) \code{shapeLayout} object to facilitate proper
insertion of carcass data into ring structure.}

\item{ncarcReset}{boolean to direct the function to set the carcass counts
in all the rings to 0 before adding the new carcasses (default) or to add the
new carcasses to the old totals (\code{ncarcReset = FALSE}).}

\item{ccCol}{name of carcass class column (optional). Typically, the "carcass 
class" would be for carcass characteristics that would be expected to affect
distances that carcasses would fall from the turbine. For example, distances 
would not be expected to be the same for large and small carcasses, and bats
may have significantly different distance distributions than small birds. The ccCol
could also be used for subsetting by any covariate that would be expected 
to interact with carcass distance distributions, like season (if winds vary 
by season) or turbine type (if the site has a diverse mix of turbines of 
different sizes or types). Additionally, ccCol can be used to subset the data by area 
(for example, NW, NE, SW, SE; or hilltop, river bank) or any other discrete 
covariate that the user may be interested in.}

\item{unitCol}{name of unit column}

\item{rCol}{name of column with carcass distances}
}
\value{
an object of class \code{rings} with a tally of the number of
 of carcasses discovered in each concentric 1m ring from the turbine to the 
 most distant point searched.
}
\description{
After the site layout is analyzed and structured by rings for analysis,
 carcass data may still need to be added to the site data. \code{addCarcass}
 grabs carcass location data from a shape file or data frame and formats it
 into ring data, with carcass tallies in every 1m ring from the turbine to
 the maximum search distance away from any turbine.
}
\examples{
 data(layout_simple)
 data(carcass_simple)
 sitedata <- initLayout(layout_simple)
 ringdata <- prepRing(sitedata)
 ringsWithCarcasses <- addCarcass(carcass_simple, data_ring = ringdata)
}
