% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inside.R
\name{inside}
\alias{inside}
\title{Check Whether Numeric Value Falls Inside Two Other Numeric Values}
\usage{
inside(x, ends, inclusive = TRUE)
}
\arguments{
\item{x}{Numeric value or vector of numeric values.}

\item{ends}{Numeric vector of length 2 specifying the endpoints for the 
interval, or a 2-column numeric matrix where each row specifies a pair of 
endpoints.}

\item{inclusive}{Logical value indicating whether endpoints should be 
included.}
}
\value{
Logical value or vector.
}
\description{
Returns \code{TRUE} if \code{x} falls inside range defined by \code{ends}
and \code{FALSE} otherwise. Also works for multiple sets of values and/or
endpoints.
}
\examples{
# Check whether 2 is inside [0, 2.5]
inside(1, c(0, 2.5))

# Check whether 2 and 3 are inside (0, 3)
inside(c(2, 3), c(0, 3), inclusive = FALSE)

# Check whether 1 is inside [1, 2] and [3, 4]
inside(1, rbind(c(1, 2), c(3, 4)))

}
