\name{dots.bars}
\alias{dots.bars}
\title{
Plot Points +/- Error Bars
}
\description{
Creates plot showing user-specified points (e.g. means, medians, regression
coefficients) along with user-specified error bars (e.g. standard deviations,
min/max, 95\% confidence intervals).
}
\usage{
dots.bars(y = NULL,
          bars = NULL,
          bars.lower = y - bars,
          bars.upper = y + bars,
          group.labels = NULL,
          subgroup.labels = NULL,
          subgroup.pch = NULL,
          subgroup.col = NULL,
          points.list = NULL,
          arrows.list = NULL,
          axis.list = NULL,
          legend.list = NULL,
          ...)
}
\arguments{
  \item{y}{
Numeric vector of y-values for different groups, or numeric matrix where each
column contains y-values for clustered subgroups within a group.
}
  \item{bars}{
Numeric vector or matrix (matching whichever type \code{y} is) specifying the
length of the error bar for each group/subgroup (i.e. distance from point to
one end of error bar).
}
  \item{bars.lower}{
Numeric vector or matrix (matching whichever type \code{y} is) specifying the
position of the lower end of the error bar for each group/subgroup.
}
  \item{bars.upper}{
Numeric vector or matrix (matching whichever type \code{y} is) specifying the
position of the upper end of the error bar for each group/subgroup.
}
  \item{group.labels}{
Character vector giving labels for the groups.
}
  \item{subgroup.labels}{
Character vector giving labels for the subgroups.
}
  \item{subgroup.pch}{
Plotting symbol for different subgroups within each group.
}
  \item{subgroup.col}{
Plotting color for different subgroups within each group.
}
  \item{points.list}{
Optional list of inputs to pass to \code{\link{points}} function.
}
  \item{arrows.list}{
Optional list of inputs to pass to \code{\link{arrows}} function.
}
  \item{axis.list}{
Optional list of inputs to pass to \code{\link{axis}} function.
}
  \item{legend.list}{
Optional list of inputs to pass to \code{\link{legend}} function.
}
  \item{...}{
Additional arguments to pass to \code{\link{plot}} function.
}
}
\details{

NA
}
\value{
Plot showing points +/- error bars across groups/subgroups.
}
\references{
The use of \code{\link{arrows}} to create error bars is taken from user465139 on
Stack Overflow (\url{https://stackoverflow.com/questions/13032777/scatter-plot-with-error-bars})

Acknowledgment: This material is based upon work supported by the National
Science Foundation Graduate Research Fellowship under Grant No. DGE-0940903.
}
\author{
Dane R. Van Domelen
}
\note{
NA
}
\seealso{
NA
}
\examples{
# Generate 100 values from normal distributions with different means, and graph
# mean +/- standard deviation across groups
dat <- cbind(rnorm(100, 2), rnorm(100, 2.5), rnorm(100, 1.75))
means <- apply(dat, 2, mean)
sds <- apply(dat, 2, sd)
fig1 <- dots.bars(y = means, bars = sds, main = "Mean +/- SD by Group",
                    ylab = "Mean +/- SD")

# Simulate BMI values for males and females in 3 different age groups, and graph
# mean +/- 95\% CI
sex <- as.factor(c(rep("Male", 300), rep("Female", 300)))
age <- as.factor(rep(c("Young", "Middle", "Old"), 2))
bmi <- c(rnorm(100, 25, 4), rnorm(100, 26, 4.25), rnorm(100, 27, 4.5),
         rnorm(100, 26.5, 4.5), rnorm(100, 27.25, 4.75), rnorm(100, 28, 5))
dat <- data.frame(sex = sex, age = age, bmi = bmi)
means <- tapply(dat$bmi, dat[, c("sex", "age")], mean)
ci.lower <- tapply(dat$bmi, dat[, c("sex", "age")],
                   function(x) t.test(x)$conf.int[1])
ci.upper <- tapply(dat$bmi, dat[, c("sex", "age")],
                   function(x) t.test(x)$conf.int[2])
fig2 <- dots.bars(y = means, bars.lower = ci.lower, bars.upper = ci.upper,
                    main = "BMI by Sex and Age",
                    ylab = "BMI (mean +/- CI)",
                    xlab = "Age group")
}
