% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dviData.R
\name{dviData}
\alias{dviData}
\alias{checkDVI}
\title{DVI data}
\usage{
dviData(pm, am, missing, generatePairings = TRUE)

checkDVI(
  dvi,
  pairings = NULL,
  errorIfEmpty = FALSE,
  ignoreSex = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{pm}{A list of singletons: The victim samples.}

\item{am}{A list of pedigrees: The reference families.}

\item{missing}{A character vector with names of missing persons.}

\item{generatePairings}{A logical. If TRUE (default) a list of sex-compatible
pairings is included as part of the output.}

\item{dvi}{A \code{dviData} object.}

\item{pairings}{A list of pairings.}

\item{errorIfEmpty}{A logical.}

\item{ignoreSex}{A logical.}

\item{verbose}{A logical.}
}
\value{
An object of class \code{dviData}, which is basically a list of \code{pm},
\code{am}, \code{missing} and \code{pairings}.
}
\description{
DVI data
}
\examples{
dvi = dviData(pm = singleton("V1"), am = nuclearPed(1), missing = "3")
dvi

checkDVI(dvi)

}
