% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mergePM.R
\name{directMatch}
\alias{directMatch}
\title{Direct match LR}
\usage{
directMatch(x, y, geno1 = NULL, geno2 = NULL)
}
\arguments{
\item{x, y}{Typed singletons.}

\item{geno1, geno2}{(Optional) Named character vectors with genotypes for \code{x}
and \code{y} respectively.}
}
\value{
A nonnegative likelihood ratio.
}
\description{
Computes the likelihood ratio comparing if two samples are from the same
individual or from unrelated individuals.
}
\examples{

pm = singletons(c("V1", "V2", "V3")) |> 
  addMarker(V1 = "1/1", V2 = "2/2", V3 = "1/1", 
            afreq = c("1" = 0.01, "2" = 0.99), name = "L1")

directMatch(pm[[1]], pm[[2]])
directMatch(pm[[1]], pm[[3]])

}
\seealso{
\code{\link[=mergePM]{mergePM()}}.
}
