% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/db_extension.R
\name{ddbs_load}
\alias{ddbs_load}
\title{Loads the Spatial extension}
\usage{
ddbs_load(conn)
}
\arguments{
\item{conn}{a connection object to a DuckDB database}
}
\value{
TRUE (invisibly) for successful installation
}
\description{
Checks if a spatial extension is installed, and loads it in a DuckDB database
}
\examples{
## load packages
library(duckdb)
library(duckspatial)

## connect to in memory database
conn <- dbConnect(duckdb::duckdb())

## install the spatial exntesion
ddbs_install(conn)
ddbs_load(conn)

## disconnect from db
dbDisconnect(conn)

}
