# Generated by 02-duckplyr_df-methods.R
#' @export
intersect.duckplyr_df <- function(x, y, ...) {
  # Our implementation
  check_dots_empty()
  check_compatible(x, y)

  x_names <- names(x)
  y_names <- names(y)
  if (identical(x_names, y_names)) {
    # Ensure identical() is very cheap
    y_names <- x_names
  }

  rel_try(call = list(name = "intersect", x = x, y = y),
    "No duplicate names" = !identical(x_names, y_names) && anyDuplicated(x_names) && anyDuplicated(y_names),
    "Tables of different width" = length(x_names) != length(y_names),
    "Name mismatch" = !identical(x_names, y_names) && !all(y_names %in% x_names),
    {
      if (oo_force()) {
        both <- semi_join(x, y, by = x_names)
        out <- distinct(both)
      } else {
        x_rel <- duckdb_rel_from_df(x)
        y_rel <- duckdb_rel_from_df(y)
        if (!identical(x_names, y_names)) {
          # FIXME: Select by position
          exprs <- nexprs_from_loc(x_names, set_names(seq_along(x_names), x_names))
          y_rel <- rel_project(y_rel, exprs)
        }

        rel <- rel_set_intersect(x_rel, y_rel)
        out <- rel_to_df(rel)
        out <- dplyr_reconstruct(out, x)
      }
      return(out)
    }
  )

  # dplyr forward
  intersect <- dplyr$intersect.data.frame
  out <- intersect(x, y, ...)
  return(out)

  # dplyr implementation
  check_dots_empty()
  check_compatible(x, y)

  out <- vec_set_intersect(x, y, error_call = current_env())

  dplyr_reconstruct(out, x)
}

duckplyr_intersect <- function(x, y, ...) {
  try_fetch(
    {
      x <- as_duckplyr_df(x)
      y <- as_duckplyr_df(y)
    },
    error = function(e) {
      testthat::skip(conditionMessage(e))
    }
  )
  out <- intersect(x, y, ...)
  class(out) <- setdiff(class(out), "duckplyr_df")
  out
}
